import sys
import termios
import fcntl
import struct

def get_current_column():
    """Get current terminal column number.

        :return: number of columns
        :rtype: `list`
        :raises: if cannot detect columns number: IOError(25,
                 'Inappropriate ioctl for device')

    """
    try:
        data = fcntl.ioctl(sys.stdout.fileno(),
                termios.TIOCGWINSZ, u'1234')
        return struct.unpack('hh', data)[1]
    except (IOError, ValueError):
        return 80
