# -*- coding: utf-8 -*-
#
##########################################################################
# pyeole.diagnose - Diagnostic tools for EOLE
# Copyright © 2014 Pôle de compétences EOLE <eole@ac-dijon.fr>
#
# License CeCILL:
#  * in french: http://www.cecill.info/licences/Licence_CeCILL_V2-fr.html
#  * in english http://www.cecill.info/licences/Licence_CeCILL_V2-en.html
##########################################################################

import sys

if sys.version_info[0] < 3:
    from network import test_udp, test_tcp
    from diagnose import (test_http, compare_iptables, compare_ipset,
                          test_freshclam, test_clamd, test_pyclamd, test_maj,
                          test_maj_reconfigure, test_need_reboot,
                          NOT_AVAILABLE, OK, NOK, test_containers)

    __all__ = ('test_udp', 'test_tcp', 'test_http', 'compare_iptables',
               'compare_ipset', 'test_freshclam', 'test_clamd', 'test_pyclamd',
               'test_maj', 'test_maj_reconfigure', 'test_need_reboot',
               'NOT_AVAILABLE', 'OK', 'NOK', 'test_containers')
else:
    __all__ = ()
