# -*- coding: utf-8 -*-
#
# Copyright © 2014 Pôle de compétences EOLE <eole@ac-dijon.fr>
#
# License CeCILL:
#  * in french: http://www.cecill.info/licences/Licence_CeCILL_V2-fr.html
#  * in english http://www.cecill.info/licences/Licence_CeCILL_V2-en.html
##########################################################################

"""
Encoding utilities
"""
import unicodedata, sys

# this function has been unproudly borrowed from here :
# http://stackoverflow.com/questions/517923/what-is-the-best-way-to-remove-accents-in-a-python-unicode-string

def remove_accents(input_str):
    nfkd_form = unicodedata.normalize('NFKD', input_str)
    only_ascii = nfkd_form.encode('ASCII', 'ignore')
    return only_ascii

def normalize(string):
    """
    Always return unicode
    """
    if sys.version_info[0] >= 3:
        return string
    if not isinstance(string, unicode):
        for encoding in ['utf-8', 'iso-8859-1', 'ascii']:
            try:
                string = string.decode(encoding)
                break
            except:
                pass
    return string
