# -*- coding: utf-8 -*-

#########################################################################
# pyeole.service - manage EOLE services
# Copyright © 2012-2013 Pôle de Compétence EOLE <eole@ac-dijon.fr>
#
# License CeCILL:
#  * in french: http://www.cecill.info/licences/Licence_CeCILL_V2-fr.html
#  * in english http://www.cecill.info/licences/Licence_CeCILL_V2-en.html
#########################################################################

from os.path import splitext as _splitext, dirname as _dirname,\
    abspath as _abspath, basename as _basename
from glob import glob as _glob


def get_modules():
    _mods = {}
    _modules = _glob(_abspath(_dirname(__file__)) + '/*.py')
    for _module in _modules:
        _module = _splitext(_basename(_module))[0]
        if not _module.startswith('_') and not _module == 'get_modules':
            _mods[_module] = __import__('pyeole.service.module.'+_module)
    return _mods
