#!/usr/bin/env python

import hashlib, os
from base64 import encodestring as encode
from base64 import decodestring as decode


# unproudly borrowed from
# http://www.openldap.org/faq/data/cache/347.html
def ssha_encode(password):
    salt = os.urandom(4)
    h = hashlib.sha1(password)
    h.update(salt)
    return "{SSHA}" + encode(h.digest() + salt)

def ssha_check(challenge_password, password):
    challenge_bytes = decode(challenge_password[6:])
    digest = challenge_bytes[:20]
    salt = challenge_bytes[20:]
    hr = hashlib.sha1(password)
    hr.update(salt)
    return digest == hr.digest()


