# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2009
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################
"""
    Affectation des identifiant uniques ENT aux utilisateurs
"""
from zephir.manage_pool import get_ids, get_single_id

def get_one_entlogin():
    """
        récupération d'un nouveau login ENT
    """
    pool = get_single_id()
    if pool is not None:
        new_id = pool.get_next_id()
        pool.save_state()
        return new_id
    else:
        return False

def _entlogin_user(ldapuser):
    """
        vérification et affectation des login ENT
    """
    uid_liste = []
    ldapuser.ldap_admin.connect()
    filtre = "%s(ENTPersonLogin=*)" % ldapuser.filtre
    for user in ldapuser._get_users(filtre=filtre, attrs=['uid', 'ENTPersonLogin']):
        if user['uid'] == user['ENTPersonLogin']:
            uid_liste.append(user['uid'][0])
    login_needed = len(uid_liste)
    if login_needed != 0:
        pool = get_ids(login_needed)
        if pool is not None:
            current_id = pool.get_next_id()
            for user in uid_liste:
                ldapuser._set_attr(user, "ENTPersonLogin", current_id)
                pool.save_state()
                current_id = pool.get_next_id()
        else:
            pass
            # pas assez d'identifiants ou code ent indéterminé
    ldapuser.ldap_admin.close()

# Attention aux imports croisés ;)

def entlogin_eleves():
    """ login ENT élèves """
    from eleves import Eleve
    _entlogin_user(Eleve())

def entlogin_enseignants():
    """ login ENT enseignants """
    from enseignants import Enseignant
    _entlogin_user(Enseignant())

def entlogin_administratifs():
    """ login ENT administratifs """
    from administratifs import Administratif
    _entlogin_user(Administratif())

def entlogin_responsables():
    """ login ENT responsables """
    from responsables import Responsable
    _entlogin_user(Responsable())

def entlogin_autres():
    """ login ENT autres """
    from autres import Autre
    _entlogin_user(Autre())

