# -*- coding: utf-8 -*-
###########################################################################
#
# Eole NG - 2010
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  http://www.cecill.info/licences/Licence_CeCILL_V2-fr.html
# eole@ac-dijon.fr
#
###########################################################################
"""
 librairie pour le parsing des fichiers de données

 - parse_csv_eleves : parsing des fichiers CSV/Scribe élèves
 - parse_csv_profs  : parsing des fichiers CSV/Scribe enseignants
 - parse_csv_administratifs : parsing des fichiers CSV/Scribe personnels
 - parse_csv_invites : parsing des fichiers CSV/Scribe comptes invités
"""
from csv import DictReader
from scribe.eoletools import convert_file, replace_cars, replace_more_cars
from scribe.importation import log
from scribe.importation.config import DEBUG_NUM
from scribe.storage import Eleve, Niveau, Classe, Enseignant, Administratif, \
    Invite, EnsClasse, JointureClasseEnseignant, Groupe, JointureGroupeUser

def read_csv(csvfile, fields):
    """
    ouverture et test du fichier CSV
    """
    # fichier en UTF-8 ?
    convert_file(csvfile)
    reader = DictReader(file(csvfile), delimiter=';')
    # validation en-tête
    # ATTENTION : ça commence direct par le 1er enregistrement
    data = reader.next()
    for field in fields:
        if not data.has_key(field):
            msg = "Le champ \"%s\" n'est pas présent dans l'en-tête du fichier !" % field
            log.errorlog(msg)
            raise Exception(msg)
    return reader, data

##########################################
# Extraction CSV Elèves (version 2)
# Fichier :
# - eleves.csv
##########################################
def parse_csv_eleves(storage, csvfile):
    """
    parsing des élèves
    """
    num = 0
    log.infolog("Lecture des élèves...", title=True)
    # champs obligatoires
    fields = ['numero', 'nom', 'prenom', 'sexe', 'date',
              'classe', 'niveau']
    # champs optionnels : ['login', 'password', 'options']
    reader, data = read_csv(csvfile, fields)
    while True:
        eleve = {}
        eleve['numero'] = unicode(data['numero'])
        eleve['int_id'] = u''
        eleve['nom'] = unicode(replace_more_cars(data['nom']))
        eleve['prenom'] = unicode(replace_more_cars(data['prenom']))
        if data['sexe'] == 'F':
            eleve['civilite'] = u'3' #Mlle
        else:
            eleve['civilite'] = u'1' #M.
        eleve['date'] = unicode(data['date'])
        # champs facultatifs
        options = data.get('options', '').split('|')
        if data.has_key('login') and data['login']:
            eleve['force_login'] = unicode(replace_more_cars(data['login']))
            if data.has_key('password') and data['password']:
                eleve['force_password'] = unicode(data['password'])
        try:
            niveau = unicode(replace_cars(data['niveau']))
            if not niveau:
                raise TypeError("niveau invalide")
            classe = unicode(replace_cars(data['classe']))
            if not classe:
                raise TypeError("classe invalide")
            my_eleve = Eleve(store=storage, **eleve)
            my_niveau = storage.findOrCreate(Niveau, nom=niveau)
            my_classe = storage.findOrCreate(Classe, nom=classe,
                                             niveau=my_niveau)
            # affectation de l'élève
            my_eleve.classe = my_classe
            my_eleve.niveau = my_niveau
            # association élève-options
            for option in options:
                if option != '':
                    nom = unicode(replace_cars(option))
                    groupe = storage.findOrCreate(Groupe, nom=nom)
                    JointureGroupeUser(store=storage, groupe=groupe,
                                       user=my_eleve)
            num += 1
            if num % DEBUG_NUM == 0:
                log.debuglog("%d élèves lus..." % num)
        except TypeError, msg:
            log.errorlog("Erreur sur l'élève %s : %s" % (data['numero'], msg))
        try:
            data = reader.next()
        except StopIteration:
            break
    log.infolog("TOTAL : %d élèves" % num)


##########################################
# Extraction CSV Enseignants (version 2)
# Fichier :
# - enseignants.csv
##########################################
def parse_csv_profs(storage, csvfile):
    """
    parsing des enseignants
    """
    num = 0
    log.infolog("Lecture des enseignants...", title=True)
    # champs obligatoires
    fields = ['numero', 'nom', 'prenom', 'sexe', 'date']
    # champs optionnels : ['login', 'password', 'classes', 'options']
    reader, data = read_csv(csvfile, fields)
    while True:
        professeur = {}
        professeur['int_id'] = unicode(data['numero'])
        professeur['nom'] = unicode(replace_more_cars(data['nom']))
        professeur['prenom'] = unicode(replace_more_cars(data['prenom']))
        if data['sexe'] == 'F':
            professeur['civilite'] = u'2' #Mme
        else:
            professeur['civilite'] = u'1' #M.
        professeur['date'] = unicode(data['date'])
        # champs facultatifs
        classes = data.get('classes', '').split('|')
        options = data.get('options', '').split('|')
        if data.has_key('login') and data['login']:
            professeur['force_login'] = unicode(data['login'])
            if data.has_key('password') and data['password']:
                professeur['force_password'] = unicode(data['password'])
        try:
            prof = Enseignant(store=storage, **professeur)
            num += 1
        except Exception, msg:
            log.infolog("Erreur sur l'enseigant %s : %s" % (data['numero'], msg))
        else:
            # association enseignant-classes
            for classe in classes:
                if classe != '':
                    nom = unicode(replace_cars(classe))
                    my_classe = storage.findOrCreate(EnsClasse, nom=nom)
                    JointureClasseEnseignant(store=storage, classe=my_classe,
                            enseignant=prof, profprincipal=False)
            # association enseignant-options
            for option in options:
                if option != '':
                    nom = unicode(replace_cars(option))
                    groupe = storage.findOrCreate(Groupe, nom=nom)
                    JointureGroupeUser(store=storage, groupe=groupe, user=prof)
        if num % DEBUG_NUM == 0:
            log.debuglog("%d enseignants lus..." % num)
        try:
            data = reader.next()
        except StopIteration:
            break
    log.infolog("TOTAL : %d enseignants" % num)


##########################################
# Extraction CSV Personnels administratifs
# Fichier :
# - personnels.csv
##########################################
def parse_csv_administratifs(storage, csvfile):
    """
    parsing des personnels
    """
    num = 0
    log.infolog("Lecture des personnels...", title=True)
    # champs obligatoires
    fields = ['numero', 'nom', 'prenom', 'sexe', 'date']
    # champs optionnels : ['login', 'password']
    reader, data = read_csv(csvfile, fields)
    while True:
        professeur = {}
        professeur['int_id'] = unicode(data['numero'])
        professeur['nom'] = unicode(replace_more_cars(data['nom']))
        professeur['prenom'] = unicode(replace_more_cars(data['prenom']))
        if data['sexe'] == 'F':
            professeur['civilite'] = u'2' #Mme
        else:
            professeur['civilite'] = u'1' #M.
        professeur['date'] = unicode(data['date'])
        if data.has_key('login') and data['login']:
            professeur['force_login'] = unicode(data['login'])
            if data.has_key('password') and data['password']:
                professeur['force_password'] = unicode(data['password'])
        try:
            Administratif(store=storage, **professeur)
            num += 1
        except Exception, msg:
            log.infolog("Erreur sur le personnel %s : %s" % (data['numero'], msg))
        if num % DEBUG_NUM == 0:
            log.debuglog("%d personnels lus..." % num)
        try:
            data = reader.next()
        except StopIteration:
            break
    log.infolog("TOTAL : %d personnels" % num)


##########################################
# Extraction CSV Comptes invités
# Fichier :
# - invites.csv
##########################################
def parse_csv_invites(storage, csvfile):
    """
    parsing des comptes invités
    """
    num = 0
    log.infolog("Lecture des comptes invités...", title=True)
    # champs obligatoires
    fields = ['nom', 'prenom', 'sexe', 'date']
    # champs optionnels : ['login', 'password']
    reader, data = read_csv(csvfile, fields)
    while True:
        professeur = {}
        # FIXME
        #professeur['int_id'] = u''
        professeur['nom'] = unicode(replace_more_cars(data['nom']))
        professeur['prenom'] = unicode(replace_more_cars(data['prenom']))
        if data['sexe'] == 'F':
            professeur['civilite'] = u'2' #Mme
        else:
            professeur['civilite'] = u'1' #M.
        professeur['date'] = unicode(data['date'])
        if data.has_key('login') and data['login']:
            professeur['force_login'] = unicode(data['login'])
            if data.has_key('password') and data['password']:
                professeur['force_password'] = unicode(data['password'])
        try:
            Invite(store=storage, **professeur)
            num += 1
        except Exception, msg:
            log.infolog("Erreur sur le compte %s %s : %s" % (data['prenom'], data['nom'], msg))
        if num % DEBUG_NUM == 0:
            log.debuglog("%d comptes lus..." % num)
        try:
            data = reader.next()
        except StopIteration:
            break
    log.infolog("TOTAL : %d comptes invités" % num)

