#!/usr/bin/python
# -*- coding: iso-8859-1 -*-

import os, commands
from string import ascii_letters

home = '/home'

def create_eleve_dirs(rep):
    dico = dict(rep = rep)
    cmd = """[ ! -d "%(rep)s/perso/prive" ] && mkdir -p %(rep)s/perso/prive
""" % dico
    os.system(cmd)

def create_prof_dirs(rep):
    dico = dict(rep = rep)
    cmd = """[ ! -d "%(rep)s/perso" ] && mkdir -p %(rep)s/perso
""" % dico
    os.system(cmd)

def create_adm_dirs(rep):
    dico = dict(rep = rep)
    cmd = """[ ! -d "%(rep)s/perso" ] && mkdir -p %(rep)s/perso
""" % dico
    os.system(cmd)

def get_groupe(user):
    cmde = 'id %s|grep eleves' % user
    cmdp = 'id %s|grep professeurs' % user
    cmda = 'id %s|grep administratifs' % user
    if commands.getstatusoutput(cmde)[0] == 0:
        return 'eleve'
    if commands.getstatusoutput(cmdp)[0] == 0:
        return 'professeur'
    if commands.getstatusoutput(cmda)[0] == 0:
        return 'administratif'
    return None

def place_droit(user, rep):
    dico = dict(user = user, rep = rep)
    drte = """setfacl -Rbk %(rep)s
chown -R root:root %(rep)s
setfacl -PRm u::rwx,g::---,o::--- %(rep)s
setfacl -PRm u:%(user)s:rwx %(rep)s
getfacl --access --absolute-names  %(rep)s | setfacl -d -M- %(rep)s
setfacl -m g:professeurs:--x %(rep)s
setfacl -PRm g:professeurs:r-x %(rep)s/perso
getfacl --access --absolute-names %(rep)s/perso | setfacl -dR -M- %(rep)s/perso
if [ -d %(rep)s/perso/prive ];then
setfacl -m g:professeurs:--- %(rep)s/perso/prive
getfacl --access --absolute-names  %(rep)s/perso/prive | setfacl -d -M- %(rep)s/perso/prive
fi
# pour les quotas
chown -R %(user)s %(rep)s/perso
""" % dico

    drtp = """setfacl -Rbk %(rep)s
chown -R root:root %(rep)s
setfacl -PRm u:%(user)s:rwx %(rep)s
getfacl --access --absolute-names  %(rep)s | setfacl -dR -M- %(rep)s
chown -R %(user)s %(rep)s/perso
""" % dico

    drta = drtp

    grp = get_groupe(user)
    if not grp:
        print '  ###  Utilisateur %s non trouvé  ###' % user
    print "Traitement de", user, grp
    if grp == 'eleve':
        create_eleve_dirs(rep)
        os.system(drte)
        return
    if grp == 'professeur':
        create_prof_dirs(rep)
        os.system(drtp)
        return
    if grp == 'administratif':
        create_adm_dirs(rep)
        os.system(drta)
        return

for i in ascii_letters:
    rep = os.path.join(home, i)
    print rep
    if not os.path.isdir(rep): continue
    users = os.listdir(rep)
    for user in users:
        rep2 = os.path.join(rep, user)
        #print user, rep2, rep
        place_droit(user, rep2)
