#!/usr/bin/env python
# -*- coding: UTF-8 -*-

#########################################################
# utilitaire de suppression d'utilisateur dans un annuaire LDAP
# licence GPL Eole
# conception apr Bruno Boiget <bruno.boiget@ac-dijon.fr>
#########################################################

###################
# modules importés
import sys
import ldap
import ldif
from os import system,remove,removedirs
from scribe.backend_conf import *

#####################
# variables globales
#####################

homebase = "/home"

###########################
# définition des fonctions
###########################

####################
# boucle principale
def main():

    
    help = "suppression_utilisateur.py <utilisateur>\n";
    
    # récupération des arguments de la ligne de commande
    try:
        users = sys.argv[1]
    except:
        sys.exit("\n"+help)

    liste_users = users.split(",")

    # suppression de l'utilisateur dans la base

    # faut il supprimer également son répertoire ?
    sup_rep=""
    while ((sup_rep.upper() != "O") and (sup_rep.upper() != "N")):
        sup_rep = raw_input("faut-il supprimer les répertoires personnels ? (O/N) :")

    valid = ""
    while ((valid.upper() != "O") and (valid.upper() != "N")):
        valid = raw_input("Confirmez vous la suppression (O/N) ?")

    if (valid.upper() != "O"):
        sys.exit("\nsuppression annulée\n")

    for user in liste_users:
        if sup_rep == "O":
            retour = system("/usr/sbin/smbldap-userdel -r "+user)
        else:
            retour = system("/usr/sbin/smbldap-userdel "+user)
        if retour != 0:
            print("erreur lors de la supression (utilisateur inexistant ou problème LDAP) !\n")
        else:
            print("utilisateur "+user+" supprimé\n")
            

# si on a appelé le programme directement : on éxecute main
if __name__ == "__main__":
    main()
