#-*-coding:utf-8*-*
from scribe.autres import Autre

autre_test = {'login':'__autre__test__',
              'password':'eole',
             'nom':'__autrenom__',
             'prenom':'__test__',
             'date':'12/03/1954',
             'civilite':'1',
             'mail':'a@a.com',
            }

class TestAutre:
    """
        Test de la classe Autre
    """
    username = autre_test['login']

    def setup_class(cls):
        cls.autre = Autre()
        cls.autre.ldap_admin.connect()

    def test_add(self):
        self.autre._add(**autre_test)

    def test_is_user(self):
        assert self.autre._is_user(self.username)
        assert self.autre._get_attr(self.username, 'mail') == [autre_test['mail']]
        assert self.username in self.autre._get_autres()

    def test_delete(self):
        self.autre._delete(self.username, remove_data=True)
        assert not self.autre._is_user(self.username)

    def teardown_class(cls):
        cls.autre.ldap_admin.close()

