#! /usr/bin/env python
# -*- coding: utf-8 -*-
###########################################################################
#
# Eole NG
# Copyright Pole de Competence Eole (Ministere Education - Academie Dijon)
# Licence CeCill  http://www.cecill.info/licences/Licence_CeCILL_V2-fr.html
# eole@ac-dijon.fr
#
###########################################################################
"""
Primitives ldap pour Seshat
(copie partielle des librairies Scribe-2.2)
"""
import ldap
import sha, random, base64
from os.path import isfile
SUFFIX = 'o=gouv,c=fr'
LDAPCONF = '/etc/eole/eoleldap.conf'

if isfile(LDAPCONF):
    # fournit : ldap_server, ldap_admin, ldap_passwd
    execfile(LDAPCONF)
else:
    raise Exception("Fichier %s non trouvé" % LDAPCONF)

def to_list(data):
    """
        formatage chaine ou liste en liste sans doublons ;)
    """
    if data is None:
        return data
    elif data == '':
        return []
    elif not hasattr(data, '__iter__'):
        return list(set([data]))
    else:
        return list(set(data))

def sshaDigest(passphrase, salt=None):
    """ returns a ssha digest (sha-1 with salt)
    this can be used to encrypt a passphrase
    using sha-1 encryption, with salt.
    compatible with openldap fields
    """
    # copié de :
    # http://www.koders.com/python/fidEBC010168CA74647BD40FDB1AD96C44A611E94B9.aspx?s=cdef%3Atimer
    if salt is None:
        salt = ''
        for i in range(8):
            salt += chr(random.randint(0, 255))
    s = sha.sha()
    s.update(passphrase)
    s.update(salt)
    encoded = base64.encodestring(s.digest()+salt).rstrip()
    crypt = '{SSHA}' + encoded
    return crypt

class Ldap(object):
    """
        Interface de connection à un serveur ldap
    """

    def __init__(self, serveur=None, passwd=None, binddn=None):
        if serveur is None:
            self.serveur = ldap_server
        else:
            self.serveur = serveur
        if passwd is None:
            self.passwd = ldap_passwd
            self.local_passwd = True
        else:
            self.passwd = passwd
            self.local_passwd = False
        if binddn == None:
            self.binddn = ldap_admin
        else:
            self.binddn = binddn
        self.connexion = None

    def reload_pwd(self):
        """
            recharge le mot de passe
        """
        if self.local_passwd:
            execfile(LDAPCONF)
            self.passwd = ldap_passwd

    def connect(self):
        """
            binding ldap si nécessaire
        """
        if not self.connexion:
            self.reload_pwd()
            self.connexion = ldap.open(self.serveur)
            self.connexion.simple_bind_s(self.binddn, self.passwd)

    def close(self):
        """
            fermeture de la connexion ldap
        """
        if self.connexion:
            self.connexion.unbind()
            self.connexion = None

    def _add(self, dn , data):
        """
            ajout d'une entrée ldap
        """
        self.connexion.add_s(dn, data)

    def _delete(self, dn):
        """
            suppression d'une entrée ldap
        """
        self.connexion.delete(dn)

    def _modify(self, dn, data):
        """
            modification d'une entrée ldap
        """
        self.connexion.modify_s(dn, data)

    def _search(self, filtre, attrlist=None):
        """
            recherche dans l'annuaire
        """
        attrlist = to_list(attrlist)
        return self.connexion.search_s(SUFFIX, ldap.SCOPE_SUBTREE,
                                filtre, attrlist)

    def _search_one(self, filtre, attrlist=None):
        """
           recherche une entrée dans l'annuaire
        """
        result = self._search(filtre, attrlist)
        if len(result) > 0 and len(result[0]) == 2:
            return result[0][1]
        else:
            return {}

