# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2009
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################
"""
"""
from glob import glob
from os import system
from os.path import basename
from axiom.store import Store
from axiom.item import Item
from axiom.attributes import text, integer
from pyeole.service import manage_service

CONFIGS = ['/etc/ldap/replication/replication-*.conf', '/etc/ldap/replication/zephir/replication-*.conf']
STORAGE_FILE = '/usr/share/ead2/backend/tmp/replication.db'

class Etablissement(Item):
    """
    Définition de la base SQLite pour l'attribution des RID de réplication
    """
    typeName = 'etablissement'
    schemaVersion = 1
    rid = integer(allowNone=False)
    rne = text(allowNone=False)

def gen_replication_config(configfile='/etc/ldap/replication.conf', restart=True):
    """
    Génération du fichier de configuration des fournisseurs
    """
    etabs = {}
    storage = Store(STORAGE_FILE)
    for etab in storage.query(Etablissement):
        etabs[etab.rne] = etab.rid
    if etabs != {}:
        index = max(etabs.values())+1
    else:
        index = 0

    result = []
    configs = []
    for glob_conf in CONFIGS:
        configs.extend(glob(glob_conf))
    for config in configs:
        rne = unicode(basename(config)[12:-5])
        if rne in etabs:
            rid = etabs[rne]
        else:
            rid = index
            Etablissement(store=storage, rid=index, rne=rne)
            index += 1
        try:
            result.append(file(config).read() % rid)
        except:
            print "fichier de configuration %s invalide" % config

    fic = file(configfile, 'w')
    fic.writelines(result)
    fic.close()

    if restart:
        manage_service('restart', 'slapd')
        # relance du service EoleSSO (maj des infos établisements) #12822
        manage_service('reload', 'eole-sso')
