#! /usr/bin/env python
# -*- coding:utf8 -*-
###########################################################################
# Eole NG - 2010
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill: http://www.cecill.info/licences/Licence_CeCILL_V2-fr.html
# eole@ac-dijon.fr
###########################################################################
"""Intégration EleveID/Teleservices
Le but est de générer un identifiant à partir de différentes infos connues
dans l'annuaire. Il servira de clef de fédération pour les parents et les
élèves pour l'acces aux téléservices (SCONET).
"""
import sys
import ldap
import shelve
from os.path import isfile
from creole.client import CreoleClient

REPLICATION = "/etc/ldap/replication.conf"
DATABASE_FREDU = "/usr/share/sso/integrTeleservice.db"
DATABASE_INTID = "/usr/share/sso/reverseTeleservice.db"
# filtres pour les differentes branches
USER_FILTER = "(objectclass=inetOrgPerson)(!(description=Computer))"
GROUP_FILTER = "(objectclass=sambaGroupMapping)(objectclass=posixGroup)"
COMPUTER_FILTER = "(description=Computer)(objectclass=posixAccount)"
SHARE_FILTER = "(objectClass=sambaFileShare)"
ELEVE_FILTER = "%s(objectClass=Eleves)" % USER_FILTER
PROF_FILTER = "%s(objectClass=Administrateur)" % USER_FILTER
ADMINISTRATIF_FILTER = "%s(objectClass=administratif)" % USER_FILTER
RESPONSABLE_FILTER = "%s(objectClass=responsable)" % USER_FILTER
AUTRE_FILTER = "%s(objectClass=autre)" % USER_FILTER

def get_rne_from_user(user_info):
    if type(user_info[1].get('ENTEleveStructRattach', '')) is list \
        and user_info[1]['ENTEleveStructRattach']:
        rne = user_info[1]['ENTEleveStructRattach'][0]
    elif 'ou=education,o=gouv,c=fr' in user_info[0]:
        rne = user_info[0].split(',ou=')[-3]
    else:
        # FIXME
        rne = ''
    return rne

print "** Génération de la base contenant les vecteurs d'identité **"

if not isfile(REPLICATION):
    sys.exit("Erreur : pas de fichier %s" % REPLICATION)

dico = CreoleClient().get_creole()
# recherche de la configuration de l'annuaire local.
ip_eth0 = dico['adresse_ip_eth0']
ldap_ok = 0
index_ldap = 0
for ldap_serv in dico['eolesso_ldap']:
    if ldap_serv in (ip_eth0, 'localhost', '127.0.0.1',
                     dico['container_ip_annuaire']):
        ldap_ok = index_ldap
    index_ldap += 1
ldap_serv = dico['eolesso_ldap'][ldap_ok]
#suffix = dico['base_ldap_sso'][ldap_ok]
root_dn = dico['eolesso_ldap.eolesso_ldap_reader'][ldap_ok]
root_pwd_file = dico['eolesso_ldap.eolesso_ldap_reader_passfile'][ldap_ok]
academie = dico['nom_academie'] # pas multi ;)
root_pwd = file(root_pwd_file).read().strip()

connexion = ldap.open(ldap_serv)
connexion.simple_bind_s(root_dn, root_pwd)

# 'r'     Open existing database for reading only (default)
# 'w'     Open existing database for reading and writing
# 'c'     Open database for reading and writing, creating it if it doesn’t exist
# 'n'     Always create a new, empty database, open for reading and writing
db_fredu = shelve.open(DATABASE_FREDU, 'n')
# db_intid : base inversée pour retrouver l'attribut intid depuis FrEduVecteur
db_intid = shelve.open(DATABASE_INTID, 'n')

# recherche des établissements répliqués dans replication.conf
etabs = []
repdata = file(REPLICATION).read().split()
for data in repdata:
    if "searchbase" in data:
        etabs.append(data.split('"')[1])

if not etabs:
    print("Aucun établissement répliqué trouvé dans %s" % REPLICATION)
    sys.exit(0)

print
# parcours des établissements
for searchbase in etabs:
    print "* Traitement de l'établissement %s *" % searchbase.split(',')[0][3:]

    # recherche des élèves
    good = 0
    eleves = connexion.search_s(searchbase, ldap.SCOPE_SUBTREE,
                                '(&%s(ENTEleveStructRattachId=*))' % ELEVE_FILTER, # FIXME
                                ['ENTEleveStructRattachId', 'ENTEleveStructRattach', 'intid'])
    for eleve in eleves:
        # clé en minuscule pour éviter les ou avec une casse exotique
        dn = eleve[0].lower()
        profil = '4' # FIXME
        eleveid = eleve[1].get('ENTEleveStructRattachId', [''])[0]
        intid = eleve[1].get('intid', [''])[0]
        if not eleveid:
            continue
        etab = get_rne_from_user(eleve)
        vecteur = '|'.join([profil, '', '', eleveid, etab])
        db_fredu[dn] = [vecteur]
        if intid:
            db_intid[vecteur] = intid
        good += 1
    print "%d vecteurs élève générés sur %d élèves possédant l'attribut ENTEleveStructRattachId" % (good, len(eleves))

    # recherche des responsables légaux
    good = 0
    responsables = connexion.search_s(searchbase, ldap.SCOPE_SUBTREE,
                                      '(&%s)' % RESPONSABLE_FILTER,
                                      ['sn', 'givenName', 'ENTAuxPersRelEleveEleve', 'eleve', 'intid'])
    for responsable in responsables:
        data = []
        dn = responsable[0]
        profil = '2' # FIXME
        nom = responsable[1]['sn'][0]
        prenom = responsable[1]['givenName'][0]
        intid = responsable[1].get('intid', [''])[0]
        for eleve in responsable[1]['ENTAuxPersRelEleveEleve']:
            eleve = eleve.lower()
            if eleve in db_fredu:
                eleveid, etab = db_fredu[eleve][0].split('|')[-2:]
                vecteur_rel = '|'.join([profil, nom, prenom, eleveid, etab])
                data.append(vecteur_rel)
                if intid:
                    db_intid[vecteur_rel] = intid
            else:
                # FIXME
                #print "!! élève non retrouvé !!", eleve
                continue
        if data:
            db_fredu[dn] = data
            good += 1
    print "%d vecteurs responsable générés sur %d responsables" % (good, len(responsables))
    print

db_fredu.close()
db_intid.close()
connexion.unbind_s()
print "** Fin de la génération **"
