# -*- coding: utf-8 -*-
###########################################################################
# Eole - 2007-2015
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# backend.py
#
# librairie pour la gestion du module Seshat
#
###########################################################################

from creole.client import CreoleClient
from os.path import isfile

MAIL_PATH = CreoleClient().get_creole('container_path_mail')
ROUTES_FILE = MAIL_PATH + '/etc/mail/routes'
RELAY_FILE = MAIL_PATH + '/etc/mail/relayhosts'
EAD_ROUTES = '/var/lib/eole/config/routes.ead'

def gen_routes():
    """
    génération des fichiers /etc/mail/routes et /etc/mail/relayhosts
    """
    if isfile(EAD_ROUTES):
        fha = file(EAD_ROUTES, 'r')
        # With python2.7, two with statements can be joined with a comma
        # with file(ROUTES_FILE, 'w') as route_h, file(RELAY_FILE, 'w') as relay_h:
        with file(ROUTES_FILE, 'w') as route_h:
            with file(RELAY_FILE, 'w') as relay_h:
                for line in fha:
                    split = line.split('#')
                    try:
                        # routing is "Domain: IP"
                        route_h.write("%s: %s" % (split[0], split[1]))
                        route_h.write("i-%s: %s" % (split[0], split[1]))
                        # relay authorisation is "IP"
                        relay_h.write(split[1])
                    except:
                        pass
