#!/bin/bash

# Utilisation des couleurs et autres
. /usr/lib/eole/ihm.sh

# Initialisation variables
# Groupe à traiter
Groupe="admin-pneam"
# Groupes d'appartenance
ListeGroupes=("Denied RODC Password Replication Group")
# Compte psin pour la supervision
Compte_pneam="SynchroAmande"

# Récupération du dn du domaine
dnDomaine="$(ldbsearch -H /var/lib/samba/private/sam.ldb '(&(objectclass=OrganizationalUnit)(ou=Services))' cn | awk '/dn: / {print $2}'|cut -d, -f2-)"

# Création du compte Compte_pneam s'il n'existe pas
echo
EchoVert "Creation du compte $Compte_pneam"
Existe_Compte_pneam=$(samba-tool user list|grep -i ${Compte_pneam})
if [ -z "$Existe_Compte_pneam" ]; then 
	# creation du compte
	res=$(samba-tool user create $Compte_pneam password='$eole&123456$')
	ret=${?}
	if [ ${ret} -eq 0 ] ; then 
		printf ".  %$((len_pf+1))s creation => OK\n"
		# son mot de passe n'expire jamais
		res=$(samba-tool user setexpiry $Compte_pneam --noexpiry)
		ret=${?}
		if [ ${ret} -eq 0 ] ; then printf ".  %$((len_pf+1))s son mot de passe n'expire jamais => OK\n" ; fi
	fi
	EchoRouge "!!!! ATTENTION !!! ATTENTION !!! ATTENTION !!! ATTENTION !!! ATTENTION !!! ATTENTION !!!!"
	EchoRouge "!!!! Il faudra modifier le mot de passe du compte $Compte_pneam avec les outils RSAT !!!!"
	EchoRouge "!!!! ATTENTION !!! ATTENTION !!! ATTENTION !!! ATTENTION !!! ATTENTION !!! ATTENTION !!!!"
else
	printf ".  %$((len_pf+1))s Le compte $Compte_pneam existe déjà => OK\n"
	printf ".  %$((len_pf+1))s Aucune modification n'est faite sur ce compte\n"
fi
echo

# Creation du groupe s'il n'existe pas
EchoVert "Creation du groupe $Groupe"
Existe_Groupe=$(samba-tool group list|grep -i ${Groupe})
if [ -z "$Existe_Groupe" ]; then 
	res=$(samba-tool group add $Groupe)
	ret=${?}
	if [ ${ret} -eq 0 ] ; then printf ".  %$((len_pf+1))s creation => OK\n" ; fi
else
	printf ".  %$((len_pf+1))s le groupe existe deja => OK\n"
fi
echo

# Ajout du compte Compte_pneam dans le "Groupe"
EchoVert "Initilisation du groupe $Groupe"
echo "- Ajout de $Compte_pneam dans le groupe $Groupe"
res=$(samba-tool group addmembers $Groupe $Compte_pneam)
ret=${?}
if [ ${ret} -eq 0 ] ; then printf ".  %$((len_pf+1))s ajout => OK\n\n"; fi

# Ajout du "Groupe" dans les groupes listés dans "ListeGroupes"
EchoVert "Ajout de $Groupe dans le groupe :"
for index in "${!ListeGroupes[@]}"
	do
		echo "- ${ListeGroupes[$index]}"
		res=$(samba-tool group addmembers "${ListeGroupes[$index]}" $Groupe)
		if [ ${ret} -eq 0 ] ; then printf ".  %$((len_pf+1))s ajout => OK\n"; fi
	done
echo

# Récupération du sid du groupe "Groupe"
pneam_sid="$(ldbsearch -H /var/lib/samba/private/sam.ldb "(&(objectclass=Group)(cn=${Groupe}))" objectsid | awk '/objectSid: / {print $2}')"

#	*********************
#	* Objet Utilisateur *
#	*********************
# Permissions pour le "Groupe" pour les objets Utilisateur
EchoVert "Ajout des permissions de $Groupe sur les objets => Utilisateur"

#	******************
#	* sur l'OU Users *
#	******************
printf ".  %$((len_pf+1))s sur l'OU Users\n"
dnUsers="CN=Users,"$dnDomaine

#	Appliquer à "cet objet et tous ceux descendants" la création et suppression "des objets Utilisateur" 
res=$(samba-tool dsacl set --objectdn "$dnUsers" --sddl "(OA;CI;CCDC;{BF967ABA-0DE6-11D0-A285-00AA003049E2};;${pneam_sid})")
ret=${?}
ret=${?}
if [ ${ret} -eq 0 ] ; then 
	printf "%$((len_pf+1))s=> creation et suppression des objets Utilisateur : " ; EchoVert "OK"
else 
	EchoRouge "Erreur sur Appliquer à cet objet et tous ceux descendants la creation et suppression des objets Utilisateur"
fi

#	Contrôle total Appliquer à "Objets Utilisateur descendants"
res=$(samba-tool dsacl set --objectdn "$dnUsers" --sddl "(OA;CIIO;CCDCLCSWRPWPDTLOCRSDRCWDWO;;{BF967ABA-0DE6-11D0-A285-00AA003049E2};${pneam_sid})")
ret=${?}
if [ ${ret} -eq 0 ] ; then 
	printf "%$((len_pf+1))s=> contrôle total Appliquer a Objets Utilisateur descendants : " ; EchoVert "OK"
else 
	EchoRouge "Erreur sur Controle total Appliquer a Objets Utilisateur descendants"
fi
echo

#	*********************
#	* sur les OU Amande *
#	*********************
# Recherche des OU Amande
dnOUsAmande="$(ldbsearch -H /var/lib/samba/private/sam.ldb '(&(objectclass=OrganizationalUnit)(OU=Amande*))' dn | awk '/dn: / {print $2}')"
for dnOUAmande in $dnOUsAmande ;
	do
		printf ".  %$((len_pf+1))s sur l'OU $dnOUAmande\n"
		#	Appliquer à "cet objet et tous ceux descendants" la création et suppression "des objets Utilisateur" 
		res=$(samba-tool dsacl set --objectdn "$dnOUAmande" --sddl "(OA;CI;CCDC;{BF967ABA-0DE6-11D0-A285-00AA003049E2};;${pneam_sid})")
		ret=${?}
		if [ ${ret} -eq 0 ] ; then 
			printf "%$((len_pf+1))s=> creation et suppression des objets Utilisateur : " ; EchoVert "OK"
		else 
			EchoRouge "Erreur sur Appliquer à cet objet et tous ceux descendants la creation et suppression des objets Utilisateur"
		fi
		
		#	Contrôle total Appliquer à "Objets Utilisateur descendants"
		res=$(samba-tool dsacl set --objectdn "$dnOUAmande" --sddl "(OA;CIIO;CCDCLCSWRPWPDTLOCRSDRCWDWO;;{BF967ABA-0DE6-11D0-A285-00AA003049E2};${pneam_sid})")
		ret=${?}
		if [ ${ret} -eq 0 ] ; then 
			printf "%$((len_pf+1))s=> contrôle total Appliquer a Objets Utilisateur descendants : " ; EchoVert "OK"
		else 
			EchoRouge "Erreur sur Controle total Appliquer a Objets Utilisateur descendants"
		fi
		echo
	done
echo

#	****************
#	* Objet Groupe *
#	****************
# Permissions pour le "Groupe" pour les objets Groupe
EchoVert "Ajout des permissions de $Groupe sur les objets => Groupe"

#	*************************
#	* sur les OU HorsAmande *
#	*************************
dnOUsHorsAmande="$(ldbsearch -H /var/lib/samba/private/sam.ldb '(&(objectclass=OrganizationalUnit)(OU=HorsAmande*))' dn | awk '/dn: / {print $2}')"
for dnOUHorsAmande in $dnOUsHorsAmande ;
	do
		printf ".  %$((len_pf+1))s sur l'OU $dnOUHorsAmande\n"
		#	Appliquer à "cet objet et tous ceux descendants" la création et suppression "des objets Groupe" 
		res=$(samba-tool dsacl set --objectdn "$dnOUHorsAmande" --sddl "(OA;CI;CCDC;{BF967A9C-0DE6-11D0-A285-00AA003049E2};;${pneam_sid})")
		ret=${?}
		if [ ${ret} -eq 0 ] ; then 
			printf "%$((len_pf+1))s=> creation et suppression des objets Groupe : " ; EchoVert "OK"
		else 
			EchoRouge "Erreur sur Appliquer à cet objet et tous ceux descendants la creation et suppression des objets Groupe"
		fi

		#	Contrôle total Appliquer à "Objets Groupe descendants"
		res=$(samba-tool dsacl set --objectdn "$dnOUHorsAmande" --sddl "(OA;CIIO;CCDCLCSWRPWPDTLOCRSDRCWDWO;;{BF967A9C-0DE6-11D0-A285-00AA003049E2};${pneam_sid})")
		ret=${?}
		if [ ${ret} -eq 0 ] ; then 
			printf "%$((len_pf+1))s=> contrôle total Appliquer a Objets Groupe descendants : " ; EchoVert "OK"
		else 
			EchoRouge "Erreur sur Controle total Appliquer a Objets Groupe descendants"
		fi
		echo
		
	done
echo
exit 0

