#!/bin/bash

# Utilisation des couleurs et autres
. /usr/lib/eole/ihm.sh

# Initialisation variables
# Fichier de configuration des comptes administrateurs psin et pnesr
Fichier="ConfAdmins.cf"
# Groupe à traiter
Groupe="admin-pnesr"
# Groupes d'appartenance
ListeGroupes=("Denied RODC Password Replication Group" "DnsAdmins" "integrateurs")

# Récupération du dn du domaine
dnDomaine="$(ldbsearch -H /var/lib/samba/private/sam.ldb '(&(objectclass=OrganizationalUnit)(ou=Services))' cn | awk '/dn: / {print $2}'|cut -d, -f2-)"

echo
EchoVert "Indexation de l attribut Destination-Indicator pour le domaine $Domaine"
#Indexation de l'attribut Destination-Indicator :
# - Cet attribut fait le lien entre un objet AD et un objet LDAP
# - son indexation optimise les performances de mise à jour par le script PNE-AM
echo "dn: CN=Destination-Indicator,CN=Schema,CN=Configuration,"$dnDomaine > searchflagsDI.ldif
echo "changetype: modify" >> searchflagsDI.ldif
echo "replace: searchFlags" >> searchflagsDI.ldif
echo "searchFlags: 1" >> searchflagsDI.ldif
fichier_schema=$(ls -l /var/lib/samba/private/sam.ldb.d/ |grep SCHEMA|awk '{print $NF}')
res=$(ldbmodify -H "/var/lib/samba/private/sam.ldb.d/"$fichier_schema searchflagsDI.ldif)
ret=${?}
if [ ${ret} -eq 0 ] ; then
	printf ".  %$((len_pf+1))s indexation => OK\n"
else
	EchoRouge "Erreur d indexation sur le fichier $fichier_schema"
fi

# Creation du groupe s'il n'existe pas
echo
EchoVert "Creation du groupe $Groupe"
Existe_Groupe=$(samba-tool group list|grep -i ${Groupe})
if [ -z "$Existe_Groupe" ]; then
	res=$(samba-tool group add $Groupe)
	ret=${?}
	if [ ${ret} -eq 0 ] ; then printf ".  %$((len_pf+1))s creation => OK\n" ; fi
else
	printf ".  %$((len_pf+1))s le groupe existe deja => OK\n"
fi
echo


# Ajout des comptes listés dans "Fichier" pour le "Groupe"
if [ -f $Fichier ]; then
	EchoVert "Initilisation du groupe $Groupe"
    while read line
    do
		compte=$(echo $line|cut -d" " -f1)
		GroupeFichier=$(echo $line|cut -d" " -f2)
		if [ "$GroupeFichier" = "$Groupe" ]; then
			Existe_Compte=$(samba-tool user list|grep -i ${compte})
			if [ -z "$Existe_Compte" ]; then
				EchoRouge "Le compte $compte n'existe pas"
			else
				printf ".  %$((len_pf+1))s ajout de $compte dans le groupe $Groupe\n"
				res=$(samba-tool group addmembers $Groupe $compte)
				ret=${?}
				#EchoRouge "retour commande ${ret}"
			fi
		fi
    done < $Fichier
else
    EchoRouge "Le fichier $Fichier n'existe pas"
    exit 1
fi
echo

# Ajout du "Groupe" dans les groupes listés dans "ListeGroupes"
EchoVert "Ajout de $Groupe dans le groupe :"
for index in "${!ListeGroupes[@]}"
	do
		echo "- ${ListeGroupes[$index]}"
		res=$(samba-tool group addmembers "${ListeGroupes[$index]}" $Groupe)
		if [ ${ret} -eq 0 ] ; then printf ".  %$((len_pf+1))s ajout => OK\n"; fi
	done
echo

# Permissions pour le "Groupe" sur le domaine
EchoVert "Ajout des permissions de $Groupe sur le domaine $dnDomaine"

# Récupération du sid du groupe "Groupe"
pnesr_sid="$(ldbsearch -H /var/lib/samba/private/sam.ldb "(&(objectclass=Group)(cn=${Groupe}))" objectsid | awk '/objectSid: / {print $2}')"

#	************************
#	* Unité d'Organisation *
#	************************
printf ".  %$((len_pf+1))s permissions sur les objets => Unité d'Organisation\n"
#	Appliquer à "cet objet et tous ceux descendants" la création et suppression "des objets Unité d'Organisation"
res=$(samba-tool dsacl set --objectdn "$dnDomaine" --sddl "(OA;CI;CCDC;{BF967AA5-0DE6-11D0-A285-00AA003049E2};;${pnesr_sid})")
ret=${?}
if [ ${ret} -eq 0 ] ; then
	printf "%$((len_pf+1))s=> creation et suppression des objets Unité d'Organisation : " ; EchoVert "OK"
else 
	EchoRouge "Erreur sur Appliquer à cet objet et tous ceux descendants la creation et suppression des objets Unité d Organisation"
fi

#	"Contrôle total" Appliquer à "Objets Unité d'Organisation descendants"
res=$(samba-tool dsacl set --objectdn "$dnDomaine" --sddl "(OA;CIIO;CCDCLCSWRPWPDTLOCRSDRCWDWO;;{BF967AA5-0DE6-11D0-A285-00AA003049E2};${pnesr_sid})")
ret=${?}
if [ ${ret} -eq 0 ] ; then
	printf "%$((len_pf+1))s=> contrôle total Appliquer a Objets Unité d'Organisation descendants : " ; EchoVert "OK"
else 
	EchoRouge "Erreur sur Controle total Appliquer a Objets Unité d'Organisation descendants"
fi
echo

#	***************
#	* Utilisateur *
#	***************
printf ".  %$((len_pf+1))s permissions sur les objets => Utilisateur\n"
#	Appliquer à "cet objet et tous ceux descendants" la création et suppression "des objets Utilisateur"
res=$(samba-tool dsacl set --objectdn "$dnDomaine" --sddl "(OA;CI;CCDC;{BF967ABA-0DE6-11D0-A285-00AA003049E2};;${pnesr_sid})")
ret=${?}
if [ ${ret} -eq 0 ] ; then
	printf "%$((len_pf+1))s=> creation et suppression des objets Utilisateur : " ; EchoVert "OK"
else
	EchoRouge "Erreur sur Appliquer à cet objet et tous ceux descendants la creation et suppression des objets Utilisateur"
fi

#	Contrôle total Appliquer à "Objets Utilisateur descendants"
res=$(samba-tool dsacl set --objectdn "$dnDomaine" --sddl "(OA;CIIO;CCDCLCSWRPWPDTLOCRSDRCWDWO;;{BF967ABA-0DE6-11D0-A285-00AA003049E2};${pnesr_sid})")
ret=${?}
if [ ${ret} -eq 0 ] ; then
	printf "%$((len_pf+1))s=> contrôle total Appliquer a Objets Utilisateur descendants : " ; EchoVert "OK"
else
	EchoRouge "Erreur sur Controle total Appliquer a Objets Utilisateur descendants"
fi
echo

#	**************
#	* Ordinateur *
#	**************
printf ".  %$((len_pf+1))s permissions sur les objets => Ordinateur\n"
#	Appliquer à "cet objet et tous ceux descendants" la création et suppression "des objets Ordinateur"
res=$(samba-tool dsacl set --objectdn "$dnDomaine" --sddl "(OA;CI;CCDC;{BF967A86-0DE6-11D0-A285-00AA003049E2};;${pnesr_sid})")
ret=${?}
if [ ${ret} -eq 0 ] ; then
	printf "%$((len_pf+1))s=> creation et suppression des objets Ordinateur : " ; EchoVert "OK"
else
	EchoRouge "Erreur sur Appliquer à cet objet et tous ceux descendants la creation et suppression des objets Ordinateur"
fi

#	Contrôle total Appliquer à "Objets Ordinateur descendants"
res=$(samba-tool dsacl set --objectdn "$dnDomaine" --sddl "(OA;CIIO;CCDCLCSWRPWPDTLOCRSDRCWDWO;;{BF967A86-0DE6-11D0-A285-00AA003049E2};${pnesr_sid})")
ret=${?}
if [ ${ret} -eq 0 ] ; then
	printf "%$((len_pf+1))s=> contrôle total Appliquer a Objets Ordinateur descendants : " ; EchoVert "OK"
else
	EchoRouge "Erreur sur Controle total Appliquer a Objets Ordinateur descendants"
fi
echo

#	**********
#	* Groupe *
#	**********
printf ".  %$((len_pf+1))s permissions sur les objets => Groupe\n"
#	Appliquer à "cet objet et tous ceux descendants" la création et suppression "des objets Groupe"
res=$(samba-tool dsacl set --objectdn "$dnDomaine" --sddl "(OA;CI;CCDC;{BF967A9C-0DE6-11D0-A285-00AA003049E2};;${pnesr_sid})")
ret=${?}
if [ ${ret} -eq 0 ] ; then
	printf "%$((len_pf+1))s=> creation et suppression des objets Groupe : " ; EchoVert "OK"
else
	EchoRouge "Erreur sur Appliquer à cet objet et tous ceux descendants la creation et suppression des objets Groupe"
fi

#	Contrôle total Appliquer à "Objets Groupe descendants"
res=$(samba-tool dsacl set --objectdn "$dnDomaine" --sddl "(OA;CIIO;CCDCLCSWRPWPDTLOCRSDRCWDWO;;{BF967A9C-0DE6-11D0-A285-00AA003049E2};${pnesr_sid})")
ret=${?}
if [ ${ret} -eq 0 ] ; then
	printf "%$((len_pf+1))s=> contrôle total Appliquer a Objets Groupe descendants : " ; EchoVert "OK"
else
	EchoRouge "Erreur sur Controle total Appliquer a Objets Groupe descendants"
fi
echo

exit 0

