#!/bin/bash

. /usr/lib/eole/ihm.sh

# recherche de tous les groupes *-OUADM
groups="$(ldbsearch -H /var/lib/samba/private/sam.ldb '(&(objectclass=Group)(cn=*-OUADM))' cn | awk '/cn: / {print $2}')"

for group in $groups
do
	# recuperation de l ou ou se trouve le groupe OUADM
    ou="$(ldbsearch -H /var/lib/samba/private/sam.ldb "(&(objectclass=Group)(cn=$group))" cn | awk '/dn: / {print $2}')"
    filter="CN=${group},"
	ou_OUADM=${ou#$filter}

	# recuperation sid du groupe OUADM
    ouadm_sid="$(ldbsearch -H /var/lib/samba/private/sam.ldb "(&(objectclass=Group)(cn=${group}))" objectsid | awk '/objectSid: / {print $2}')"
	echo
	EchoCyan "************************ Ajout des permissions du groupe ==> $group <== ************************"
	EchoCyan "                     =>  $ou_OUADM "
	#
	# Permissions pour le groupe " OUADM " :
	#
	#	*********************
	#	* sur l'OU Machines *
	#	*********************
	echo
	printf "*** %$((len_pf+1))s sur OU=Machines,${ou_OUADM} pour les objets " ; EchoCyan "Ordinateur"
	#
	#*** pour les objets "Ordinateur"
	#					  **********
	#	Appliquer à "cet objet et tous ceux descendants" la création et suppression "des objets Ordinateur"
	res=$(samba-tool dsacl set --objectdn "OU=Machines,${ou_OUADM}" --sddl "(OA;CI;CCDC;{BF967A86-0DE6-11D0-A285-00AA003049E2};;${ouadm_sid})")
	ret=${?}
	if [ ${ret} -eq 0 ] ; then
		printf "%$((len_pf+1))s=> creation et suppression des objets Ordinateur : " ; EchoVert "OK"
	else
		EchoRouge "Erreur sur Appliquer à cet objet et tous ceux descendants la creation et suppression des objets Ordinateur"
	fi

	#	Contrôle total Appliquer à "Objets Ordinateur descendants"
	res=$(samba-tool dsacl set --objectdn "OU=Machines,${ou_OUADM}" --sddl "(OA;CIIO;CCDCLCSWRPWPDTLOCRSDRCWDWO;;{BF967A86-0DE6-11D0-A285-00AA003049E2};${ouadm_sid})")
	ret=${?}
	if [ ${ret} -eq 0 ] ; then
		printf "%$((len_pf+1))s=> contrôle total Appliquer a Objets Ordinateur descendants : " ; EchoVert "OK"
	else
		EchoRouge "Erreur sur Controle total Appliquer a Objets Ordinateur descendants"
	fi
	#
	echo
	printf "*** %$((len_pf+1))s sur OU=Machines,${ou_OUADM} pour les objets " ; EchoCyan "Unité d'Organisation"
	#*** pour les objets "Unité d'Organisation"
	#					  ********************
	#	Appliquer à "cet objet et tous ceux descendants" la création et suppression "des objets Unité d'Organisation"
	res=$(samba-tool dsacl set --objectdn "OU=Machines,${ou_OUADM}" --sddl "(OA;CI;CCDC;{BF967AA5-0DE6-11D0-A285-00AA003049E2};;${ouadm_sid})")
	ret=${?}
	if [ ${ret} -eq 0 ] ; then
		printf "%$((len_pf+1))s=> creation et suppression des objets Unité d'Organisation : " ; EchoVert "OK"
	else
		EchoRouge "Erreur sur Appliquer à cet objet et tous ceux descendants la creation et suppression des objets Unité d Organisation"
	fi

	#	"Contrôle total" Appliquer à "Objets Unité d'Organisation descendants"
	res=$(samba-tool dsacl set --objectdn "OU=Machines,${ou_OUADM}" --sddl "(OA;CIIO;CCDCLCSWRPWPDTLOCRSDRCWDWO;;{BF967AA5-0DE6-11D0-A285-00AA003049E2};${ouadm_sid})")
	ret=${?}
	if [ ${ret} -eq 0 ] ; then
		printf "%$((len_pf+1))s=> contrôle total Appliquer a Objets Unité d'Organisation descendants : " ; EchoVert "OK"
	else
		EchoRouge "Erreur sur Controle total Appliquer a Objets Unité d'Organisation descendants"
	fi

	#
	#	***********************
	#	* sur l'OU HorsAmande *
	#	***********************
	echo
	printf "*** %$((len_pf+1))s sur OU=HorsAmande,${ou_OUADM} pour les objets " ; EchoCyan "Utilisateur"
	#
	#*** pour les objets "Utilisateur"
	#					  ***********
	#	Appliquer à "cet objet et tous ceux descendants" la création et suppression "des objets Utilisateur"
	res=$(samba-tool dsacl set --objectdn "OU=HorsAmande,${ou_OUADM}" --sddl "(OA;CI;CCDC;{BF967ABA-0DE6-11D0-A285-00AA003049E2};;${ouadm_sid})")
	ret=${?}
	if [ ${ret} -eq 0 ] ; then
		printf "%$((len_pf+1))s=> creation et suppression des objets Utilisateur : " ; EchoVert "OK"
	else
		EchoRouge "Erreur sur Appliquer à cet objet et tous ceux descendants la creation et suppression des objets Utilisateur"
	fi

	#	Contrôle total Appliquer à "Objets Utilisateur descendants"
	res=$(samba-tool dsacl set --objectdn "OU=HorsAmande,${ou_OUADM}" --sddl "(OA;CIIO;CCDCLCSWRPWPDTLOCRSDRCWDWO;;{BF967ABA-0DE6-11D0-A285-00AA003049E2};${ouadm_sid})")
	ret=${?}
	if [ ${ret} -eq 0 ] ; then
		printf "%$((len_pf+1))s=> contrôle total Appliquer a Objets Utilisateur descendants : " ; EchoVert "OK"
	else
		EchoRouge "Erreur sur Controle total Appliquer a Objets Utilisateur descendants"
	fi

	echo
	printf "*** %$((len_pf+1))s sur OU=HorsAmande,${ou_OUADM} pour les objets " ; EchoCyan "Unité d'Organisation"
	#
	#*** pour les objets "Unité d'Organisation"
	#					  ********************
	#	Appliquer à "cet objet et tous ceux descendants" la création et suppression "des objets Unité d'Organisation"
	res=$(samba-tool dsacl set --objectdn "OU=HorsAmande,${ou_OUADM}" --sddl "(OA;CI;CCDC;{BF967AA5-0DE6-11D0-A285-00AA003049E2};;${ouadm_sid})")
	ret=${?}
	if [ ${ret} -eq 0 ] ; then
		printf "%$((len_pf+1))s=> creation et suppression des objets Unité d'Organisation : " ; EchoVert "OK"
	else
		EchoRouge "Erreur sur Appliquer à cet objet et tous ceux descendants la creation et suppression des objets Unité d Organisation"
	fi

	#	"Contrôle total" Appliquer à "Objets Unité d'Organisation descendants"
	res=$(samba-tool dsacl set --objectdn "OU=HorsAmande,${ou_OUADM}" --sddl "(OA;CIIO;CCDCLCSWRPWPDTLOCRSDRCWDWO;;{BF967AA5-0DE6-11D0-A285-00AA003049E2};${ouadm_sid})")
	ret=${?}
	if [ ${ret} -eq 0 ] ; then
		printf "%$((len_pf+1))s=> contrôle total Appliquer a Objets Unité d'Organisation descendants : " ; EchoVert "OK"
	else
		EchoRouge "Erreur sur Controle total Appliquer a Objets Unité d'Organisation descendants"
	fi

	echo
	printf "*** %$((len_pf+1))s sur OU=HorsAmande,${ou_OUADM} pour les objets " ; EchoCyan "Groupe"
	#
	#*** pour les objets "Groupe"
	#					  ******
	#	Appliquer à "cet objet et tous ceux descendants" la création et suppression "des objets Groupe"
	res=$(samba-tool dsacl set --objectdn "OU=HorsAmande,${ou_OUADM}" --sddl "(OA;CI;CCDC;{BF967A9C-0DE6-11D0-A285-00AA003049E2};;${ouadm_sid})")
	ret=${?}
	if [ ${ret} -eq 0 ] ; then
		printf "%$((len_pf+1))s=> creation et suppression des objets Groupe : " ; EchoVert "OK"
	else
		EchoRouge "Erreur sur Appliquer à cet objet et tous ceux descendants la creation et suppression des objets Groupe"
	fi

	#	Contrôle total Appliquer à "Objets Groupe descendants"
	res=$(samba-tool dsacl set --objectdn "OU=HorsAmande,${ou_OUADM}" --sddl "(OA;CIIO;CCDCLCSWRPWPDTLOCRSDRCWDWO;;{BF967A9C-0DE6-11D0-A285-00AA003049E2};${ouadm_sid})")
	ret=${?}
	if [ ${ret} -eq 0 ] ; then
		printf "%$((len_pf+1))s=> contrôle total Appliquer a Objets Groupe descendants : " ; EchoVert "OK"
	else
		EchoRouge "Erreur sur Controle total Appliquer a Objets Groupe descendants"
	fi

	echo
	printf "*** %$((len_pf+1))s sur le groupe " ; EchoCyan "CN=${group}"
	#Permissions pour le groupe " OUADM " sur le groupe OUADM
	# Appliquer à "cet objet et tous ceux descendants" la lecture et l'écriture des membres
	res=$(samba-tool dsacl set --objectdn "CN=${group},${ou_OUADM}" --sddl "(OA;CI;RPWP;{BF9679C0-0DE6-11D0-A285-00AA003049E2};;${ouadm_sid})")
	ret=${?}
	if [ ${ret} -eq 0 ] ; then
		printf "%$((len_pf+1))s=> lecture et écriture des membres : " ; EchoVert "OK"
	else
		EchoRouge "Erreur sur Appliquer à cet objet et tous ceux descendants la lecture et l'écriture des membres"
	fi

	echo
	printf "*** %$((len_pf+1))s sur le groupe " ; EchoCyan "CN=${group/OUADM/PCADM}"
	#Permissions pour le groupe " OUADM " sur le groupe PCADM
	# Appliquer à "cet objet et tous ceux descendants" la lecture et l'écriture des membres
	res=$(samba-tool dsacl set --objectdn "CN=${group/OUADM/PCADM},${ou_OUADM}" --sddl "(OA;CI;RPWP;{BF9679C0-0DE6-11D0-A285-00AA003049E2};;${ouadm_sid})")
	ret=${?}
	if [ ${ret} -eq 0 ] ; then
		printf "%$((len_pf+1))s=> lecture et écriture des membres : " ; EchoVert "OK"
	else
		EchoRouge "Erreur sur Appliquer à cet objet et tous ceux descendants la lecture et l'écriture des membres"
	fi

	echo
	printf "*** %$((len_pf+1))s sur le groupe " ; EchoCyan "CN=${group/OUADM/SRVADM}"
	#Permissions	pour le groupe " OUADM " sur le groupe SRVADM
	# Appliquer à "cet objet et tous ceux descendants" la lecture et l'écriture des membres
	res=$(samba-tool dsacl set --objectdn "CN=${group/OUADM/SRVADM},${ou_OUADM}" --sddl "(OA;CI;RPWP;{BF9679C0-0DE6-11D0-A285-00AA003049E2};;${ouadm_sid})")
	ret=${?}
	if [ ${ret} -eq 0 ] ; then
		printf "%$((len_pf+1))s=> lecture et écriture des membres : " ; EchoVert "OK"
	else
		EchoRouge "Erreur sur Appliquer à cet objet et tous ceux descendants la lecture et l'écriture des membres"
	fi

	# recherche de tous les groupes RODC* dans l'ou ou_OUADM
	RO_groups="$(ldbsearch -H /var/lib/samba/private/sam.ldb '(&(objectclass=Group)(cn=RODC*))' dn | awk '/dn: / {print $2}'| grep "${ou_OUADM}")"
	for RO_group in $RO_groups
	do
		echo
		#remarque :
		# RO_group est le dn complet du groupe, ce qui n'est pas le cas pour group
		# pour l'affichage on coupe donc la chaine
		# et on garde seulement les caractères avant la 1ère virgule
		# soit la syntaxe appliquée ci-dessous : "${RO_group%%,*}"
		#
		printf "*** %$((len_pf+1))s sur le groupe " ; EchoCyan  "${RO_group%%,*}"
		#
		res=$(samba-tool dsacl set --objectdn "${RO_group}" --sddl "(OA;CI;RPWP;{BF9679C0-0DE6-11D0-A285-00AA003049E2};;${ouadm_sid})")
		ret=${?}
		if [ ${ret} -eq 0 ] ; then
			printf "%$((len_pf+1))s=> lecture et écriture des membres : " ; EchoVert "OK"
		else
			EchoRouge "Erreur sur Appliquer à cet objet et tous ceux descendants la lecture et l'écriture des membres"
		fi
	done

	# recuperation sid du groupe PCADM
	group=${group/OUADM/PCADM}
    pcadm_sid="$(ldbsearch -H /var/lib/samba/private/sam.ldb "(&(objectclass=Group)(cn=${group}))" objectsid | awk '/objectSid: / {print $2}')"
	echo
	EchoCyan "************************ Ajout des permissions du groupe ==> $group <== ************************"
	EchoCyan "                     =>  $ou_OUADM "
	#
	# Permissions pour le groupe " PCADM " :
	#
	#	*********************
	#	* sur l'OU Machines *
	#	*********************
	echo
	printf "*** %$((len_pf+1))s sur OU=Machines,${ou_OUADM} pour les objets " ; EchoCyan "Ordinateur"
	#
	#*** pour les objets "Ordinateur"
	#					  **********
	#	Appliquer à "cet objet et tous ceux descendants" la création et suppression "des objets Ordinateur"
#	res=$(samba-tool dsacl set --objectdn "OU=Machines,${ou_OUADM}" --sddl "(OA;CI;CCDC;{BF967A86-0DE6-11D0-A285-00AA003049E2};;${pcadm_sid})")
#	ret=${?}
#	if [ ${ret} -eq 0 ] ; then
#		printf "%$((len_pf+1))s=> creation et suppression des objets Ordinateur : " ; EchoVert "OK"
#	else
#		EchoRouge "Erreur sur Appliquer à cet objet et tous ceux descendants la creation et suppression des objets Ordinateur"
#	fi

	#	Contrôle total Appliquer à "Objets Ordinateur descendants"
	res=$(samba-tool dsacl set --objectdn "OU=Machines,${ou_OUADM}" --sddl "(OA;CIIO;CCDCLCSWRPWPDTLOCRSDRCWDWO;;{BF967A86-0DE6-11D0-A285-00AA003049E2};${pcadm_sid})")
	ret=${?}
	if [ ${ret} -eq 0 ] ; then
		printf "%$((len_pf+1))s=> contrôle total Appliquer a Objets Ordinateur descendants : " ; EchoVert "OK"
	else
		EchoRouge "Erreur sur Controle total Appliquer a Objets Ordinateur descendants"
	fi

done
echo

exit 0
