#!/bin/bash

# Utilisation des couleurs et autres
. /usr/lib/eole/ihm.sh

# Load rules
echo
EchoVert "**** Description et enregistrement des règles ****"
echo
# Liste des CSE GUID (extension cote client) :
# https://blogs.technet.microsoft.com/mempson/2010/12/01/group-policy-client-side-extension-list/
#
# regle desactivation chgt de mot de passe par Ctrl+Alt+Suppr
printf ".  %$((len_pf+1))s Désactiver la modification du mot de passe (option : Ctrl + Alt + Suppr)\n"
# CSE GUID :
# - {35378EAC-683F-11D2-A89A-00C04FBBCFA2} => Paramètres du registre
# - {D02B1F73-3407-48AE-BA88-E8213C6761F1} => Paramètres de stratégie utilisateur
# Type paramètres de stratégie utilisateur
gpo-tool policy register 'Utilisateur/Stratégie/Modèles d’administration/Système/Options Ctrl + Alt + Suppr/Désactiver la modification du mot de passe' '{35378EAC-683F-11D2-A89A-00C04FBBCFA2}{D02B1F73-3407-48AE-BA88-E8213C6761F1}' 'Registry.pol' 'User' 'Software\Microsoft\Windows\CurrentVersion\Policies\system;DisableChangePassword;REG_DWORD;4;{value}' 2>erreur.txt
ret=${?}
if [ ${ret} -eq 0 ] ; then
	printf "****%$((len_pf+1))s  enregistrement règle "; EchoVert "=> OK"
else
	if grep -q "Policy already in set" erreur.txt ; then
		printf "****%$((len_pf+1))s  règle déjà enregistrée "; EchoVert "=> OK"
	else
		EchoRouge "!!!! Erreur enregistrement règle !!!!"
	fi
fi
echo
# regle attribution de droits a un compte/groupe pour ajout de stations de travail au domaine
printf ".  %$((len_pf+1))s Ajouter des stations de travail au domaine\n"
# CSE GUID :
# - {827D319E-6EAC-11D2-A4EA-00C04F79F83A} => Sécurité
# - {803E14A0-B4FB-11D0-A0D0-00A0C90F574B} => Groupes restreints par ordinateur
gpo-tool policy register 'Machine/Stratégie/Paramètres Windows/Paramètres de sécurité/Stratégies locales/Attribution des droits d’utilisateur/Ajouter des stations de travail au domaine' '{827D319E-6EAC-11D2-A4EA-00C04F79F83A}{803E14A0-B4FB-11D0-A0D0-00A0C90F574B}' 'GptTmpl.inf' 'Machine/Microsoft/Windows NT/SecEdit' '[Privilege Rights]\nSeMachineAccountPrivilege = {group}' 2>erreur.txt
ret=${?}
if [ ${ret} -eq 0 ] ; then
	printf "****%$((len_pf+1))s  enregistrement règle "; EchoVert "=> OK"
else
	if grep -q "Policy already in set" erreur.txt ; then
		printf "****%$((len_pf+1))s  règle déjà enregistrée "; EchoVert "=> OK"
	else
		EchoRouge "!!!! Erreur enregistrement règle !!!!"
	fi
fi
echo
# regle d'association d un compte/groupe a un groupe local (stations de travail)
printf ".  %$((len_pf+1))s Association d un compte/groupe a un groupe local (stations de travail)\n"
# CSE GUID :
# - {827D319E-6EAC-11D2-A4EA-00C04F79F83A} => Sécurité
# - {803E14A0-B4FB-11D0-A0D0-00A0C90F574B} => Groupes restreints par ordinateur
gpo-tool policy register 'Machine/Stratégie/Paramètres Windows/Paramètres de sécurité/Groupes restreints' '{827D319E-6EAC-11D2-A4EA-00C04F79F83A}{803E14A0-B4FB-11D0-A0D0-00A0C90F574B}' 'GptTmpl.inf' 'Machine/Microsoft/Windows NT/SecEdit' '[Group Membership]\n{group}__Memberof = {sup_group}\n{group}__Members = {sub_group}' 2>erreur.txt
ret=${?}
if [ ${ret} -eq 0 ] ; then
	printf "****%$((len_pf+1))s  enregistrement règle "; EchoVert "=> OK"
else
	if grep -q "Policy already in set" erreur.txt ; then
		printf "****%$((len_pf+1))s  règle déjà enregistrée "; EchoVert "=> OK"
	else
		EchoRouge "!!!! Erreur enregistrement règle !!!!"
	fi
fi
echo

# Get group names
# recherche de tous les groupes *PCADM
groups="$(ldbsearch -H /var/lib/samba/private/sam.ldb '(&(objectclass=Group)(cn=*-PCADM))' cn | awk '/cn: / {print $2}')"

# saisie mot de passe administrator
EchoCyan "Saisir le mot de passe du compte administrator"
read -r -s -p "Password : " password
echo ; echo

EchoVert "**** Création des GPO et liaison ****"
echo "-------------------------------------"
# Création des GPO et liaison
for group in $groups
do
	printf ".  %$((len_pf+1))s Création de la GPO admin_local_${group}\n"
	#
    # creation gpo "admin_local_*PCADM"
	#
    res=$(samba-tool gpo create "admin_local_${group}" -U administrator%$password 2>erreur.txt)
	ret=${?}
	if [ ${ret} -eq 0 ] ; then
		printf "****%$((len_pf+1))s  création "; EchoVert "=> OK"
	else
		if grep -q "GPO already existing" erreur.txt ; then
			printf "****%$((len_pf+1))s  la GPO existe déjà "; EchoVert "=> OK"
		else
			EchoRouge "!!!! Erreur création !!!!"
		fi
	fi
	
	# recuperation ID de la gpo
    guid="$(ldbsearch -H /var/lib/samba/private/sam.ldb "(&(objectclass=groupPolicyContainer)(displayName=admin_local_${group}))" cn | awk '/cn: / {print $2}')"

	# recuperation de l ou ou se trouve le groupe PCADM
    ou="$(ldbsearch -H /var/lib/samba/private/sam.ldb "(&(objectclass=Group)(cn=$group))" cn | awk '/dn: / {print $2}')"

	# recuperation DN du groupe PCADM
    filter="CN=${group},"

	printf ".  %$((len_pf+1))s Liaison de la GPO à ${ou#$filter}\n"
	#
    # liaison de la gpo
	#
    res=$(samba-tool gpo setlink "${ou#$filter}" $guid -U administrator%$password 2>erreur.txt)
	ret=${?}
	if [ ${ret} -eq 0 ] ; then
		printf "****%$((len_pf+1))s  liaison "; EchoVert "=> OK"
	else
		if grep -q "already linked" erreur.txt ; then
			printf "****%$((len_pf+1))s  la GPO est déjà liée "; EchoVert "=> OK"
		else
			EchoRouge "!!!! Erreur liaison !!!!"
		fi
	fi

	printf ".  %$((len_pf+1))s Association à la règle compte/groupe a un groupe local (BUILTIN\Administrateurs)\n"
	# recuperation sid du groupe PCADM
    res=$(pcadm_sid="$(ldbsearch -H /var/lib/samba/private/sam.ldb "(&(objectclass=Group)(cn=${group}))" objectsid | awk '/objectSid: / {print $2}')" 2>erreur.txt)
	ret=${?}
	if [ ${ret} -ne 0 ] ; then
		EchoRouge "!!!! Erreur recuperation sid de ${group} !!!!"
	fi
	# recuperation sid du groupe OUADM (substitution de PCADM par OUADM dans la commande)
    #ouadm_sid="$(ldbsearch -H /var/lib/samba/private/sam.ldb "(&(objectclass=Group)(cn=${group/PCADM/OUADM}))" objectsid | awk '/objectSid: / {print $2}')"

	# association de la regle admin_local_PCADM à la gpo
    res=$(gpo-tool policy add "admin_local_${group}" 'Machine/Stratégie/Paramètres Windows/Paramètres de sécurité/Groupes restreints' -v group:*${pcadm_sid} -v sup_group:'BUILTIN\Administrateurs' -v sub_group:'' -U administrator%$password 2>erreur.txt)
	ret=${?}
	if [ ${ret} -eq 0 ] ; then
		printf "****%$((len_pf+1))s  association "; EchoVert "=> OK"
	else
		EchoRouge "!!!! Erreur association !!!!"
	fi

	echo "-------------------------------------"

done

printf ".  %$((len_pf+1))s Création de la GPO désactivation chgt de mot de passe par Ctrl+Alt+Suppr\n"
#
# creation gpo "admin_local_*PCADM"
#
res=$(samba-tool gpo create "Ctrl+Alt+Suppr" -U administrator%$password 2>erreur.txt)
ret=${?}
if [ ${ret} -eq 0 ] ; then
	printf "****%$((len_pf+1))s  création "; EchoVert "=> OK"
else
	if grep -q "GPO already existing" erreur.txt ; then
		printf "****%$((len_pf+1))s  la GPO existe déjà "; EchoVert "=> OK"
	else
		EchoRouge "!!!! Erreur création !!!!"
	fi
fi

# liaison de la gpo au domaine
## recuperation ID de la gpo
guid="$(ldbsearch -H /var/lib/samba/private/sam.ldb "(&(objectclass=groupPolicyContainer)(displayName=Ctrl+Alt+Suppr))" cn | awk '/cn: / {print $2}')"
# recuperation DN du domaine (l'OU "Services" sert de repere)
filter="$(ldbsearch -H /var/lib/samba/private/sam.ldb '(&(objectclass=OrganizationalUnit)(ou=Services))' cn | awk '/dn: / {print $2}'|cut -d, -f2-)"
#
printf ".  %$((len_pf+1))s Liaison de la GPO au domaine $filter\n"
# liaison de la gpo
#
res=$(samba-tool gpo setlink "$filter" $guid -U administrator%$password 2>erreur.txt)
ret=${?}
if [ ${ret} -eq 0 ] ; then
	printf "****%$((len_pf+1))s  liaison "; EchoVert "=> OK"
else
	if grep -q "already linked" erreur.txt ; then
		printf "****%$((len_pf+1))s  la GPO est déjà liée "; EchoVert "=> OK"
	else
		EchoRouge "!!!! Erreur liaison !!!!"
	fi
fi
#
printf ".  %$((len_pf+1))s Association à la règle desactivation chgt de mot de passe par Ctrl+Alt+Suppr\n"
# association de la regle desactivation chgt de mot de passe par Ctrl+Alt+Suppr
res=$(gpo-tool policy add "Ctrl+Alt+Suppr" 'Utilisateur/Stratégie/Modèles d’administration/Système/Options Ctrl + Alt + Suppr/Désactiver la modification du mot de passe' -v value:1 -U administrator%$password 2>erreur.txt)
ret=${?}
if [ ${ret} -eq 0 ] ; then
	printf "****%$((len_pf+1))s  association "; EchoVert "=> OK"
else
	EchoRouge "!!!! Erreur association !!!!"
fi

echo
EchoVert "**** Association de règles au domaine ****"
echo "------------------------------------------"
# Restrict machine junction to domain to group integrateurs
	# recuperation sid du groupe integrateurs
	integrateurs_sid="$(ldbsearch -H /var/lib/samba/private/sam.ldb "(&(objectclass=Group)(cn=integrateurs))" objectsid | awk '/objectSid: / {print $2}')"

	printf ".  %$((len_pf+1))s Association à la règle droits à integrateurs pour ajout de stations de travail à Default Domain Controllers Policy\n"
	# association de la regle "ajout de stations de travail au domaine" à la gpo
	res=$(gpo-tool policy add "Default Domain Controllers Policy" 'Machine/Stratégie/Paramètres Windows/Paramètres de sécurité/Stratégies locales/Attribution des droits d’utilisateur/Ajouter des stations de travail au domaine' -v group:*${integrateurs_sid} -U administrator%$password 2>erreur.txt)
	if [ ${ret} -eq 0 ] ; then
		printf "****%$((len_pf+1))s  association "; EchoVert "=> OK"
	else
		EchoRouge "!!!! Erreur association !!!!"
	fi
echo "------------------------------------------"


exit 0
