from tiramisu.option import OptionDescription, DynOptionDescription, SynDynOptionDescription, ChoiceOption
from tiramisu.config import SubConfig
from tiramisu.error import PropertiesOptionError
from tiramisu.setting import groups, undefined


def _(text):
    return text


class TiramisuWebRoot(object):
    def set_api(self, api, root):
        self.api = api
        if isinstance(self.api, SubConfig):
            self.rootapi = api._cfgimpl_get_context()
            self.root = self.api.cfgimpl_get_path()
        else:
            self.rootapi = api
            self.root = None

    def read_write(self):
        self.rootapi.read_write()

    def get_unrestraint_children(self, root):
        if root is None:
            children = self.api.cfgimpl_get_description()._impl_getchildren(context=self.rootapi)
        else:
            children = getattr(self.api.cfgimpl_get_description(), root)._impl_getchildren(context=self.rootapi)
        for childapi in children:
            childname = childapi.impl_getname()
            if root is None:
                path = childname
            else:
                path = root + '.' + childname
            yield path, childapi

    def get_unrestraint(self, root):
        if root is None:
            return self.api.cfgimpl_get_description()
        return getattr(self.rootapi.cfgimpl_get_description(), root)

    def get_child(self, path):
        return self.rootapi.unwrap_from_path(path)

    def get_list(self, root, subchildapi):
        for childapi in subchildapi._impl_getchildren(context=self.rootapi):
            childname = childapi.impl_getname()
            if root is None:
                path = childname
            else:
                path = root + '.' + childname
            yield path, childapi

    def manage_requires(self, require_obj, childapi, path, form, action_hide, current_action):
        for requires in childapi.impl_getrequires():
            for require in requires:
                option, expected, action, inverse, \
                    transitive, same_action = require
                option_id = require_obj.options.get(option)
                if option_id is not None and action in action_hide:
                    if current_action is None:
                        current_action = action
                    elif current_action != action:
                        if require_obj.remotable == 'none':
                            raise Exception('not remotable')
                        form.setdefault(option_id, {})[u'remote'] = True
                    for exp in expected:
                        if inverse:
                            act = u'show'
                            inv_act = u'hide'
                        else:
                            act = u'hide'
                            inv_act = u'show'
                        require_obj.requires.setdefault(path, {u'expected': {}})[u'expected'].setdefault(exp, {}).setdefault(act, []).append(option_id)
                        if isinstance(option, ChoiceOption):
                            for value in option.impl_get_values(require_obj.api):
                                if value not in expected:
                                    require_obj.requires.setdefault(path, {u'expected': {}})[u'expected'].setdefault(value, {}).setdefault(inv_act, []).append(option_id)
                        require_obj.requires[path].setdefault(u'default', {}).setdefault(inv_act, []).append(option_id)

    def manage_callbacks(self, callback_obj, path, child, options, callback, callback_params, form):
        for callbacks in callback_params.values():
            #FIXME les keys ?
            for callbk in callbacks:
                if isinstance(callbk, tuple):
                    if callbk[0] is None:  # pragma: optional cover
                        raise Exception('unsupported from now')
                    elif callback.__name__ == 'tiramisu_copy':
                        if callback_obj.clearable == 'minimum':
                            form.setdefault(options[child], {})['clearable'] = True
                        if form[options[callbk[0]]].get('remote', False) != True:
                            form.setdefault(options[callbk[0]], {})
                            form[options[callbk[0]]].setdefault('copy', []).append(format(options[child]))
                    elif options.get(callbk[0]) is not None:
                        if callback_obj.remotable == 'none':
                            raise Exception(_('option {} only works when remotable is not "none"').format(path))
                        #form.setdefault(options[callbk[0]], {})
                        #form[options[callbk[0]]]['remote'] = True
                        form.setdefault(options[child], {})
                        form[options[child]]['remote'] = True
                        break

    def get_unrestraint_child_index(self, path, index):
        return self.rootapi.unwrap_from_path(path)

    def get_child_index(self, path, index):
        return self.rootapi.unwrap_from_path(path)

    def get_properties(self, childapi, path, index=None, apply_requires=True):
        return self.api.cfgimpl_get_settings()._getproperties(childapi,
                                                              path,
                                                              apply_requires=apply_requires,
                                                              index=index)

    def get_option_option(self, childapi):
        return childapi

    def get_option(self, childapi):
        return childapi

    def get_childapi_option(self, childapi):
        return childapi

    def isoptiondescription(self, childapi):
        return isinstance(childapi, (OptionDescription, DynOptionDescription, SynDynOptionDescription))

    def get_consistencies(self, childapi):
        return childapi._get_consistencies()

    def get_callbacks(self, childapi):
        return childapi.impl_get_callback()

    def get_option_doc(self, childapi):
        return childapi.impl_getdoc()

    def get_option_default(self, childapi):
        return childapi.impl_getdefault()

    def get_ismulti(self, childapi):
        return childapi.impl_is_multi()

    def get_option_ismulti(self, childapi):
        return childapi.impl_is_multi()

    def get_option_issubmulti(self, childapi):
        return childapi.impl_is_submulti()

    def get_option_get_default_multi(self, childapi):
        return childapi.impl_getdefault_multi()

    def get_default(self, childapi):
        return childapi.impl_getdefault()

    def get_option_help(self, childapi):
        return childapi.impl_get_information(u'help', None)

    def get_option_has_dependency(self, childapi):
        return childapi.impl_has_dependency()

    def get_option_ismasterslaves(self, childapi):
        return childapi.impl_get_group_type() == groups.master

    def get_option_isslave(self, childapi):
        return childapi.impl_is_master_slaves('slave')

    def get_isslave(self, childapi):
        return childapi.impl_is_master_slaves('slave')

    def get_option_ismaster(self, childapi):
        return childapi.impl_is_master_slaves('master')

    def get_value(self, childapi, path, props, index, validate_properties):
        if props is not None:
            props = frozenset(props)
        else:
            props = undefined
        #value = self.rootapi.getattr(path, index=index, _self_properties=props)
        value = self.api.cfgimpl_get_values()._get_cached_value(childapi,
                                                                path,
                                                                validate_properties=validate_properties,
                                                                self_properties=props,
                                                                index=index)
        if isinstance(value, PropertiesOptionError):
            raise value
        return value

    def del_value(self, childapi, path, index):
        if index is None:
            delattr(self.rootapi, path)
        elif self.get_option_isslave(childapi):
            # hugly hack
            old_values = []
            multi = getattr(self.rootapi, path)
            for idx, val in enumerate(multi):
                if idx != index:
                    owner = self.rootapi.getowner(childapi,idx)
                    if owner != 'default':
                        old_values.append((idx, val, owner))
            delattr(self.rootapi, path)
            values = self.rootapi.cfgimpl_get_values()
            for idx, val, owner in old_values:
                multi[idx] = val
                values.setowner(childapi, owner, idx)
        else:
            multi = getattr(self.rootapi, path)
            multi.pop(index)

    def add_value(self, childapi, path, value):
        getattr(self.rootapi, path).append(value)

    def mod_value(self, childapi, path, index, value):
        if index is None:
            setattr(self.rootapi, path, value)
        else:
            multi = getattr(self.rootapi, path)
            if not multi and index == 0:
                multi.append(value)
            else:
                multi[index] = value

    def get_option_values(self, childapi):
        return childapi.impl_get_values(self.rootapi)

    def get_value_len(self, childapi, path):
        return len(self.get_value(childapi, path, None, None, True))

    def get_owner(self, childapi, path, index):
        values = self.api.cfgimpl_get_values()
        return values._getowner(childapi, path, None, index=index, validate_properties=False)
