const env = process.env;

// Fonction pour définir des constantes initialisées à partir des variables d'environnements
function define(name, value) {
  Object.defineProperty(exports, name, {
    value: (typeof env[name] !== "undefined" ? env[name] : value),
    enumerable: true
  });
}

// Valeur des constantes par défaut
define("MACHINE_HOST", "localhost");
define("SHOW", true);
define("INSPECT", false);
define("VARIABLES_FILE", "../../src/variables.json");
define("BROWSER_CONFIG", {
  switches: {
    'ignore-certificate-errors': true
  },
  typeInterval: 25,
  pollInterval: 2000,
  waitTimeout: 100000,
  show: (exports.SHOW == "false" ? false : true),
  openDevTools: (exports.INSPECT == "true" ? true : false)
});
