require('../actions');
const config = require('../config');
const expect = require('chai').expect;
const Browser = require('nightmare');
const spawn = require('child_process').spawn;
const fs = require('fs');

describe('tiramisu-web', () => {

  expect(config.MACHINE_HOST).to.be.not.empty;

  // Spawn server for testing
  before( (done) => {
    server = spawn('polymer', ['serve', '--entrypoint', 'test.html'], { cwd: "../../src" });
    setTimeout(() => {
      done();
    }, 2000);
  });

  // Kill server after testing
  after( (done) => {
    server.kill();
    done();
  });

  describe('Config 1', () => {

    var server = null;
    var variables = {
      "form": [
        {
          "clearable": true,
          "key": "options.unicode",
          "remote": true,
          "type": "input"
        },
        {
          "title": "Configurer",
          "type": "submit"
        }
      ],
      "model": [
        {
          "key": "options"
        },
        {
          "invalid": false,
          "key": "options.unicode",
          "owner": "default",
          "properties": [
            "empty"
          ],
          "value": []
        }
      ],
      "schema": {
        "options": {
          "mode": "basic",
          "name": "options",
          "properties": {
            "options.unicode": {
              "isMulti": true,
              "mode": "basic",
              "name": "options.unicode",
              "title": "Unicode 1",
              "type": "string",
              "value": []
            }
          },
          "title": "Common configuration",
          "type": "object"
        }
      },
      "tiramisu": [
        [],
        [],
        [],
        []
      ]
    };

    before((done) => {
      fs.writeFile(config.VARIABLES_FILE, JSON.stringify(variables), done);
    });

    after((done) => {
      fs.unlink(config.VARIABLES_FILE, done);
    });


    it('should load the form as manu wants', () => {
      const browser = new Browser(config.BROWSER_CONFIG);

      return browser
        // Load page
        .start()
        .wait((done) => {
          document.addEventListener("s_request", done);
          return s_lastRequest.url == "variables"
			&& s_lastRequest.method == "POST"
        })
        .evaluate(() => {
          return s_lastRequest;
        })
        // Fin de l'interraction
        .end()
        // Assertions
        .then(request => {
          expect(request.url).to.include('variables');
        })
      ;
    });


  });
});
