from tiramisu.option import UnicodeOption, OptionDescription
from tiramisu_web import MasterSlaves


def get_description():
    """generate description for this test
    """
    option = UnicodeOption('unicode', "Value 'test' must show MasterSlaves")
    option1 = UnicodeOption('unicode1', "Unicode master", multi=True)
    option2 = UnicodeOption('unicode2', "Unicode slave 1", multi=True)
    option3 = UnicodeOption('unicode3', "Unicode slave 2", multi=True)
    descr1 = MasterSlaves("unicode1", "Common configuration",
                          [option1, option2, option3], requires=[{'option': option,
                                                                  'expected': u'test',
                                                                  'action': 'hidden',
                                                                  'inverse': True}])
    descr = OptionDescription("options", "Common configuration", [option, descr1])
    descr = OptionDescription("unicode1_master_slaves_requires_all", "Master slave with requirement", [descr])
    return descr
