#!/usr/bin/env python
# -*- coding: utf-8 -*-
from distutils.core import setup
from os.path import dirname, abspath, join, normpath, isdir
from os import listdir


def fetch_version():
    """Get version from version.in"""
    return file('VERSION', 'r').readline().strip()


def return_storages():
    "returns all the storage plugins that are living in tiramisu/storage"
    here = dirname(abspath(__file__))
    storages_path = normpath(join(here, 'tiramisu', 'storage'))
    dir_content = [content for content in listdir(storages_path)
                   if not content == '__pycache__']
    storages = filter(isdir, [join(storages_path, content)
                      for content in dir_content])
    storage_list = ['.'.join(storage.split('/')[-3:]) for storage in storages]
    return storage_list


packages = ['tiramisu', 'tiramisu.storage']
packages.extend(return_storages())
setup(
    author="Tiramisu's team",
    author_email='contact@cadoles.com',
    name='tiramisu',
    version=fetch_version(),
    description='an options controller tool',
    url='http://tiramisu.labs.libre-entreprise.org/',
    classifiers=[
        "Programming Language :: Python",
        "Programming Language :: Python :: 2",
        "Programming Language :: Python :: 3",
        "Development Status :: 4 - Beta",
        "Environment :: Other Environment",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: GNU Library or Lesser General Public License (LGPL)",
        "Operating System :: OS Independent",
        "Topic :: Software Development :: Libraries :: Python Modules",
        "Topic :: Text Processing :: Linguistic"
    ],
    long_description="""\
An options controller tool
-------------------------------------

Due to more and more available options required to set up an operating system,
compiler options or whatever, it became quite annoying to hand the necessary
options to where they are actually used and even more annoying to add new
options. To circumvent these problems the configuration control was
introduced...

Tiramisu is an options handler and an options controller, wich aims at
producing flexible and fast options access.


This version requires Python 2.6 or later.
""",
    packages=packages
)
