import autopath
from py.test import raises
from tiramisu.config import Config
from tiramisu.option import IPOption, NetworkOption, NetmaskOption, \
    PortOption, OptionDescription


def test_ip():
    a = IPOption('a', '')
    b = IPOption('b', '', private_only=True)
    od = OptionDescription('od', '', [a, b])
    c = Config(od)
    c.a = '192.168.1.1'
    c.a = '192.168.1.0'
    c.a = '88.88.88.88'
    c.a = '0.0.0.0'
    raises(ValueError, "c.a = '255.255.255.0'")
    c.b = '192.168.1.1'
    c.b = '192.168.1.0'
    raises(ValueError, "c.b = '88.88.88.88'")
    c.b = '0.0.0.0'
    raises(ValueError, "c.b = '255.255.255.0'")

    raises(ValueError, "IPOption('a', 'ip', default='192.000.023.01')")
    d = IPOption('a', 'ip', default='192.0.23.1')
    od = OptionDescription('od', '', [d])
    c = Config(od)
    raises(ValueError, "c.a = '192.000.023.01'")

def test_ip_default():
    a = IPOption('a', '', '88.88.88.88')
    od = OptionDescription('od', '', [a])
    c = Config(od)
    c.a == '88.88.88.88'


def test_ip_reserved():
    a = IPOption('a', '')
    b = IPOption('b', '', allow_reserved=True)
    od = OptionDescription('od', '', [a, b])
    c = Config(od)
    raises(ValueError, "c.a = '226.94.1.1'")
    c.b = '226.94.1.1'


def test_network():
    a = NetworkOption('a', '')
    od = OptionDescription('od', '', [a])
    c = Config(od)
    c.a = '192.168.1.1'
    c.a = '192.168.1.0'
    c.a = '88.88.88.88'
    c.a = '0.0.0.0'
    raises(ValueError, "c.a = '255.255.255.0'")


def test_netmask():
    a = NetmaskOption('a', '')
    od = OptionDescription('od', '', [a])
    c = Config(od)
    raises(ValueError, "c.a = '192.168.1.1'")
    raises(ValueError, "c.a = '192.168.1.0'")
    raises(ValueError, "c.a = '88.88.88.88'")
    c.a = '0.0.0.0'
    c.a = '255.255.255.0'


def test_port():
    a = PortOption('a', '')
    b = PortOption('b', '', allow_zero=True)
    c = PortOption('c', '', allow_zero=True, allow_registred=False)
    d = PortOption('d', '', allow_zero=True, allow_wellknown=False, allow_registred=False)
    e = PortOption('e', '', allow_zero=True, allow_private=True)
    f = PortOption('f', '', allow_private=True)
    od = OptionDescription('od', '', [a, b, c, d, e, f])
    c = Config(od)
    raises(ValueError, "c.a = 0")
    c.a = 1
    c.a = 1023
    c.a = 1024
    c.a = 49151
    raises(ValueError, "c.a = 49152")
    raises(ValueError, "c.a = 65535")
    raises(ValueError, "c.a = 65536")

    c.b = 0
    c.b = 1
    c.b = 1023
    c.b = 1024
    c.b = 49151
    raises(ValueError, "c.b = 49152")
    raises(ValueError, "c.b = 65535")
    raises(ValueError, "c.b = 65536")

    c.c = 0
    c.c = 1
    c.c = 1023
    raises(ValueError, "c.c = 1024")
    raises(ValueError, "c.c = 49151")
    raises(ValueError, "c.c = 49152")
    raises(ValueError, "c.c = 65535")
    raises(ValueError, "c.c = 65536")

    c.d = 0
    raises(ValueError, "c.d = 1")
    raises(ValueError, "c.d = 1023")
    raises(ValueError, "c.d = 1024")
    raises(ValueError, "c.d = 49151")
    raises(ValueError, "c.d = 49152")
    raises(ValueError, "c.d = 65535")
    raises(ValueError, "c.d = 65536")

    c.e = 0
    c.e = 1
    c.e = 1023
    c.e = 1024
    c.e = 49151
    c.e = 49152
    c.e = 65535

    raises(ValueError, "c.f = 0")
    c.f = 1
    c.f = 1023
    c.f = 1024
    c.f = 49151
    c.f = 49152
    c.f = 65535
    raises(ValueError, "c.f = 65536")


def test_port_range():
    a = PortOption('a', '', allow_range=True)
    b = PortOption('b', '', allow_range=True, allow_zero=True)
    c = PortOption('c', '', allow_range=True, allow_zero=True, allow_registred=False)
    d = PortOption('d', '', allow_range=True, allow_zero=True, allow_wellknown=False, allow_registred=False)
    e = PortOption('e', '', allow_range=True, allow_zero=True, allow_private=True)
    f = PortOption('f', '', allow_range=True, allow_private=True)
    od = OptionDescription('od', '', [a, b, c, d, e, f])
    c = Config(od)
    raises(ValueError, "c.a = 0")
    c.a = 1
    c.a = 1023
    c.a = 1024
    c.a = 49151
    raises(ValueError, "c.a = 49152")
    raises(ValueError, "c.a = 65535")
    raises(ValueError, "c.a = 65536")
    c.a = '1:49151'
    raises(ValueError, "c.a = '0:49151'")
    raises(ValueError, "c.a = '1:49152'")

    c.b = 0
    c.b = 1
    c.b = 1023
    c.b = 1024
    c.b = 49151
    raises(ValueError, "c.b = 49152")
    raises(ValueError, "c.b = 65535")
    raises(ValueError, "c.b = 65536")
    c.b = '0:49151'
    raises(ValueError, "c.b = '0:49152'")

    c.c = 0
    c.c = 1
    c.c = 1023
    raises(ValueError, "c.c = 1024")
    raises(ValueError, "c.c = 49151")
    raises(ValueError, "c.c = 49152")
    raises(ValueError, "c.c = 65535")
    raises(ValueError, "c.c = 65536")
    c.c = '0:1023'
    raises(ValueError, "c.c = '0:1024'")

    c.d = 0
    raises(ValueError, "c.d = 1")
    raises(ValueError, "c.d = 1023")
    raises(ValueError, "c.d = 1024")
    raises(ValueError, "c.d = 49151")
    raises(ValueError, "c.d = 49152")
    raises(ValueError, "c.d = 65535")
    raises(ValueError, "c.d = 65536")
    raises(ValueError, "c.d = '0:0'")
    raises(ValueError, "c.d = '0:1'")

    c.e = 0
    c.e = 1
    c.e = 1023
    c.e = 1024
    c.e = 49151
    c.e = 49152
    c.e = 65535
    c.e = '0:65535'
    raises(ValueError, "c.e = '0:65536'")

    raises(ValueError, "c.f = 0")
    c.f = 1
    c.f = 1023
    c.f = 1024
    c.f = 49151
    c.f = 49152
    c.f = 65535
    raises(ValueError, "c.f = 65536")
    c.f = '1:65535'
    c.f = '3:4'
    raises(ValueError, "c.f = '0:65535'")
    raises(ValueError, "c.f = '4:3'")
