# coding: utf-8
import autopath
#from py.test import raises

from tiramisu.config import Config, GroupConfig, MetaConfig
from tiramisu.option import BoolOption, IntOption, OptionDescription
import weakref


def test_deref_storage():
    b = BoolOption('b', '')
    o = OptionDescription('od', '', [b])
    c = Config(o)
    w = weakref.ref(c.cfgimpl_get_values()._p_)
    del(c)
    assert w() is None


def test_deref_value():
    b = BoolOption('b', '')
    o = OptionDescription('od', '', [b])
    c = Config(o)
    w = weakref.ref(c.cfgimpl_get_values())
    del(c)
    assert w() is None


def test_deref_setting():
    b = BoolOption('b', '')
    o = OptionDescription('od', '', [b])
    c = Config(o)
    w = weakref.ref(c.cfgimpl_get_settings())
    del(c)
    assert w() is None


def test_deref_config():
    b = BoolOption('b', '')
    o = OptionDescription('od', '', [b])
    c = Config(o)
    w = weakref.ref(c)
    del(c)
    assert w() is None


def test_deref_option():
    b = BoolOption('b', '')
    o = OptionDescription('od', '', [b])
    w = weakref.ref(b)
    del(b)
    assert w() is not None
    del(o)
    assert w() is None


def test_deref_optiondescription():
    b = BoolOption('b', '')
    o = OptionDescription('od', '', [b])
    w = weakref.ref(o)
    del(b)
    assert w() is not None
    del(o)
    assert w() is None


def test_deref_option_cache():
    b = BoolOption('b', '')
    o = OptionDescription('od', '', [b])
    o.impl_build_cache()
    w = weakref.ref(b)
    del(b)
    assert w() is not None
    del(o)
    assert w() is None


def test_deref_optiondescription_cache():
    b = BoolOption('b', '')
    o = OptionDescription('od', '', [b])
    o.impl_build_cache()
    w = weakref.ref(o)
    del(b)
    assert w() is not None
    del(o)
    assert w() is None


def test_deref_option_config():
    b = BoolOption('b', '')
    o = OptionDescription('od', '', [b])
    c = Config(o)
    w = weakref.ref(b)
    del(b)
    assert w() is not None
    del(o)
    assert w() is not None
    del(c)
    assert w() is None


def test_deref_optiondescription_config():
    b = BoolOption('b', '')
    o = OptionDescription('od', '', [b])
    c = Config(o)
    w = weakref.ref(o)
    del(b)
    assert w() is not None
    del(o)
    assert w() is not None
    del(c)
    assert w() is None


def test_deref_groupconfig():
    i1 = IntOption('i1', '')
    od1 = OptionDescription('od1', '', [i1])
    od2 = OptionDescription('od2', '', [od1])
    conf1 = Config(od2)
    conf2 = Config(od2)
    meta = GroupConfig([conf1, conf2])
    w = weakref.ref(conf1)
    del(conf1)
    assert w() is not None
    del(meta)
    assert w() is None


def test_deref_metaconfig():
    i1 = IntOption('i1', '')
    od1 = OptionDescription('od1', '', [i1])
    od2 = OptionDescription('od2', '', [od1])
    conf1 = Config(od2)
    conf2 = Config(od2)
    meta = MetaConfig([conf1, conf2])
    w = weakref.ref(conf1)
    del(conf1)
    assert w() is not None
    del(meta)
    assert w() is None
