import autopath

from py.test import raises
from tiramisu.config import Config
from tiramisu.option import IntOption, StrOption, UnicodeOption, OptionDescription, SymLinkOption
from tiramisu.error import PropertiesOptionError, ConfigError


def make_description():
    stroption = StrOption('str', 'Test string option', default="abc",
                          properties=('mandatory', ))
    stroption1 = StrOption('str1', 'Test string option',
                           properties=('mandatory', ))
    stroption2 = UnicodeOption('unicode2', 'Test string option',
                               properties=('mandatory', ))
    stroption3 = StrOption('str3', 'Test string option', multi=True,
                           properties=('mandatory', ))
    descr = OptionDescription('tiram', '', [stroption, stroption1, stroption2, stroption3])
    return descr


def return_value(value):
    return value


def make_description2():
    stroption = StrOption('str', 'Test string option', default="abc",
                          properties=('mandatory', ))
    stroption1 = StrOption('str1', 'Test string option',
                           properties=('mandatory', ))
    stroption2 = SymLinkOption('unicode2', stroption1)
    stroption3 = StrOption('str3', 'Test string option', multi=True,
                           properties=('mandatory', ))
    unicode1 = UnicodeOption('unicode1', 'Test string option', callback=return_value, callback_params={'': ((stroption, False),)},  properties=('mandatory', ))
    descr = OptionDescription('tiram', '', [stroption, stroption1, stroption2, stroption3, unicode1])
    return descr


def make_description_sym():
    stroption = StrOption('str', 'Test string option', default="abc",
                          properties=('mandatory', ))
    stroption1 = StrOption('str1', 'Test string option',
                           properties=('mandatory', ))
    stroption2 = SymLinkOption('unicode2', stroption1)
    stroption3 = StrOption('str3', 'Test string option', multi=True,
                           properties=('mandatory', ))
    descr = OptionDescription('tiram', '', [stroption, stroption1, stroption2, stroption3])
    return descr


def make_description3():
    stroption = StrOption('str', 'Test string option', default="abc",
                          properties=('mandatory', ))
    stroption1 = StrOption('str1', 'Test string option',
                           properties=('mandatory', ))
    stroption2 = SymLinkOption('unicode2', stroption1)
    stroption3 = StrOption('str3', 'Test string option', multi=True,
                           properties=('mandatory', ))
    unicode1 = UnicodeOption('unicode1', 'Test string option', callback=return_value, callback_params={'': ((stroption, False),)},  properties=('mandatory', ))
    int1 = IntOption('int1', '', callback=return_value, callback_params={'': ((stroption, False),)},  properties=('mandatory', ))
    descr = OptionDescription('tiram', '', [stroption, stroption1, stroption2, stroption3, unicode1, int1])
    return descr


def make_description4():
    stroption = StrOption('str', 'Test string option', default="abc",
                          properties=('mandatory', ))
    stroption1 = StrOption('str1', 'Test string option',
                           properties=('mandatory', ))
    stroption2 = UnicodeOption('unicode2', 'Test string option',
                               properties=('mandatory', ))
    stroption3 = StrOption('str3', 'Test string option', multi=True, requires=[{'option': stroption, 'expected': 'yes', 'action': 'mandatory', 'transitive': False}])
    descr = OptionDescription('tiram', '', [stroption, stroption1, stroption2, stroption3])
    return descr


def test_mandatory_ro():
    descr = make_description()
    config = Config(descr)
    config.read_only()
    prop = []
    try:
        config.str1
    except PropertiesOptionError as err:
        prop = err.proptype
    assert 'mandatory' in prop
    config.read_write()
    config.str1 = 'yes'
    config.read_only()
    assert config.str1 == 'yes'


def test_mandatory_rw():
    descr = make_description()
    config = Config(descr)
    config.read_write()
    #not mandatory in rw
    config.str1
    config.str1 = 'yes'
    assert config.str1 == 'yes'


def test_mandatory_default():
    descr = make_description()
    config = Config(descr)
    config.read_only()
    #not mandatory in rw
    config.str
    config.read_write()
    config.str = 'yes'
    config.read_only()
    config.str
    config.read_write()
    config.str = None
    config.read_only()
    prop = []
    try:
        config.str
    except PropertiesOptionError as err:
        prop = err.proptype
    assert 'mandatory' in prop


#valeur vide : None, '', u'', ...
def test_mandatory_none():
    descr = make_description()
    config = Config(descr)
    config.str1 = None
    assert config.getowner(config.unwrap_from_path('str1')) == 'user'
    config.read_only()
    prop = []
    try:
        config.str1
    except PropertiesOptionError as err:
        prop = err.proptype
    assert 'mandatory' in prop


def test_mandatory_empty():
    descr = make_description()
    config = Config(descr)
    config.str1 = ''
    assert config.getowner(config.unwrap_from_path('str1')) == 'user'
    config.read_only()
    prop = []
    try:
        config.str1
    except PropertiesOptionError as err:
        prop = err.proptype
    assert 'mandatory' in prop


def test_mandatory_multi_none():
    descr = make_description()
    config = Config(descr)
    config.str3 = [None]
    config.read_only()
    assert config.getowner(config.unwrap_from_path('str3')) == 'user'
    prop = []
    try:
        config.str3
    except PropertiesOptionError as err:
        prop = err.proptype
    assert 'mandatory' in prop
    config.read_write()
    config.str3 = ['yes', None]
    config.read_only()
    assert config.getowner(config.unwrap_from_path('str3')) == 'user'
    prop = []
    try:
        config.str3
    except PropertiesOptionError as err:
        prop = err.proptype
    assert 'mandatory' in prop


def test_mandatory_multi_empty():
    descr = make_description()
    config = Config(descr)
    config.str3 = ['']
    config.read_only()
    assert config.getowner(config.unwrap_from_path('str3')) == 'user'
    prop = []
    try:
        config.str3
    except PropertiesOptionError as err:
        prop = err.proptype
    assert 'mandatory' in prop
    config.read_write()
    config.str3 = ['yes', '']
    config.read_only()
    assert config.getowner(config.unwrap_from_path('str3')) == 'user'
    prop = []
    try:
        config.str3
    except PropertiesOptionError as err:
        prop = err.proptype
    assert 'mandatory' in prop


def test_mandatory_multi_append():
    descr = make_description()
    config = Config(descr)
    config.str3 = ['yes']
    config.read_write()
    config.str3.append(None)


def test_mandatory_disabled():
    descr = make_description()
    config = Config(descr)
    setting = config.cfgimpl_get_settings()
    config.str1
    config.read_only()
    prop = []
    try:
        config.str1
    except PropertiesOptionError as err:
        prop = err.proptype
    assert prop == ['mandatory']
    setting[descr.str1].append('disabled')
    prop = []
    try:
        config.str1
    except PropertiesOptionError as err:
        prop = err.proptype
    assert set(prop) == set(['disabled', 'mandatory'])


def test_mandatory_unicode():
    descr = make_description()
    config = Config(descr)
    config.unicode2
    config.read_only()
    prop = []
    try:
        config.unicode2
    except PropertiesOptionError as err:
        prop = err.proptype
    assert prop == ['mandatory']
    config.read_write()
    config.unicode2 = u''
    config.read_only()
    prop = []
    try:
        config.unicode2
    except PropertiesOptionError as err:
        prop = err.proptype
    assert prop == ['mandatory']


def test_mandatory_warnings_ro():
    descr = make_description()
    config = Config(descr)
    config.str = ''
    config.read_only()
    proc = []
    try:
        config.str
    except PropertiesOptionError as err:
        proc = err.proptype
    assert proc == ['mandatory']
    assert list(config.cfgimpl_get_values().mandatory_warnings()) == ['str', 'str1', 'unicode2', 'str3']
    config.read_write()
    config.str = 'a'
    config.read_only()
    assert list(config.cfgimpl_get_values().mandatory_warnings()) == ['str1', 'unicode2', 'str3']
    assert list(config.cfgimpl_get_values().mandatory_warnings(force_permissive=True)) == ['str1', 'unicode2', 'str3']


def test_mandatory_warnings_rw():
    descr = make_description()
    config = Config(descr)
    config.str = ''
    config.read_write()
    config.str
    assert list(config.cfgimpl_get_values().mandatory_warnings()) == ['str', 'str1', 'unicode2', 'str3']
    config.str = 'a'
    assert list(config.cfgimpl_get_values().mandatory_warnings()) == ['str1', 'unicode2', 'str3']
    assert list(config.cfgimpl_get_values().mandatory_warnings(force_permissive=True)) == ['str1', 'unicode2', 'str3']


def test_mandatory_warnings_disabled():
    descr = make_description()
    config = Config(descr)
    config.str = ''
    setting = config.cfgimpl_get_settings()
    config.read_write()
    config.str
    assert list(config.cfgimpl_get_values().mandatory_warnings()) == ['str', 'str1', 'unicode2', 'str3']
    setting[descr.str].append('disabled')
    assert list(config.cfgimpl_get_values().mandatory_warnings()) == ['str1', 'unicode2', 'str3']
    assert list(config.cfgimpl_get_values().mandatory_warnings(force_permissive=True)) == ['str1', 'unicode2', 'str3']


def test_mandatory_warnings_hidden():
    descr = make_description()
    config = Config(descr)
    config.str = ''
    setting = config.cfgimpl_get_settings()
    config.read_write()
    config.cfgimpl_get_settings().setpermissive(('hidden',))
    config.str
    assert list(config.cfgimpl_get_values().mandatory_warnings()) == ['str', 'str1', 'unicode2', 'str3']
    setting[descr.str].append('hidden')
    assert list(config.cfgimpl_get_values().mandatory_warnings()) == ['str1', 'unicode2', 'str3']
    assert list(config.cfgimpl_get_values().mandatory_warnings(force_permissive=True)) == ['str', 'str1', 'unicode2', 'str3']


def test_mandatory_warnings_frozen():
    descr = make_description()
    config = Config(descr)
    config.str = ''
    setting = config.cfgimpl_get_settings()
    config.read_write()
    config.str
    assert list(config.cfgimpl_get_values().mandatory_warnings()) == ['str', 'str1', 'unicode2', 'str3']
    setting[descr.str].append('frozen')
    config.read_only()
    assert list(config.cfgimpl_get_values().mandatory_warnings()) == ['str', 'str1', 'unicode2', 'str3']


def test_mandatory_warnings_symlink():
    descr = make_description_sym()
    config = Config(descr)
    config.str = ''
    setting = config.cfgimpl_get_settings()
    config.read_write()
    config.str
    assert list(config.cfgimpl_get_values().mandatory_warnings()) == ['str', 'str1', 'str3']
    setting[descr.str].append('frozen')
    config.read_only()
    assert list(config.cfgimpl_get_values().mandatory_warnings()) == ['str', 'str1', 'str3']
    config.read_write()
    config.str1 = "value"
    assert list(config.cfgimpl_get_values().mandatory_warnings()) == ['str', 'str3']


def test_mandatory_warnings_validate():
    descr = make_description3()
    config = Config(descr)
    config.str = ''
    raises(ValueError, "list(config.cfgimpl_get_values().mandatory_warnings())")
    assert list(config.cfgimpl_get_values().mandatory_warnings(validate=False)) == ['str', 'str1', 'str3', 'unicode1', 'int1']
    config.str = 'test'
    raises(ValueError, "list(config.cfgimpl_get_values().mandatory_warnings())")
    assert list(config.cfgimpl_get_values().mandatory_warnings(validate=False)) == ['str1', 'str3']


def test_mandatory_warnings_validate_empty():
    descr = make_description2()
    config = Config(descr)
    config.str = ''
    config.read_only()
    raises(ConfigError, "list(config.cfgimpl_get_values().mandatory_warnings())")
    assert list(config.cfgimpl_get_values().mandatory_warnings(validate=False)) == ['str', 'str1', 'str3', 'unicode1']


def test_mandatory_warnings_is_apply_req():
    descr = make_description4()
    config = Config(descr)
    config.str = ''
    config.read_write()
    config.str
    assert list(config.cfgimpl_get_values().mandatory_warnings()) == ['str', 'str1', 'unicode2']
    config.read_only()
    assert list(config.cfgimpl_get_values().mandatory_warnings()) == ['str', 'str1', 'unicode2']
    config.read_write()
    config.str = 'yes'
    assert list(config.cfgimpl_get_values().mandatory_warnings()) == ['str1', 'unicode2', 'str3']
    assert list(config.cfgimpl_get_values().mandatory_warnings(is_apply_req=False)) == ['str1', 'unicode2']
