import autopath

from py.test import raises

from tiramisu.setting import owners
from tiramisu.config import Config, GroupConfig, MetaConfig
from tiramisu.option import IntOption, OptionDescription
from tiramisu.error import ConfigError, PropertiesOptionError

owners.addowner('meta')


def make_description():
    i1 = IntOption('i1', '')
    i2 = IntOption('i2', '', default=1)
    i3 = IntOption('i3', '')
    i4 = IntOption('i4', '', default=2)
    i5 = IntOption('i5', '', default=[2], multi=True)
    i6 = IntOption('i6', '', properties=('disabled',))
    od1 = OptionDescription('od1', '', [i1, i2, i3, i4, i5, i6])
    od2 = OptionDescription('od2', '', [od1])
    conf1 = Config(od2)
    conf2 = Config(od2)
    conf1.read_write()
    conf2.read_write()
    meta = MetaConfig([conf1, conf2])
    meta.cfgimpl_get_settings().setowner(owners.meta)
    return meta


#FIXME ne pas mettre 2 meta dans une config
#FIXME ne pas mettre 2 OD differents dans un meta
#FIXME serialization
def test_none():
    meta = make_description()
    conf1, conf2 = meta.cfgimpl_get_children()
    assert conf1.od1.i3 is conf2.od1.i3 is None
    assert conf1.getowner(conf1.unwrap_from_path('od1.i3')) is conf2.getowner(conf2.unwrap_from_path('od1.i3')) is owners.default
    meta.od1.i3 = 3
    assert conf1.od1.i3 == conf2.od1.i3 == 3
    assert conf1.getowner(conf1.unwrap_from_path('od1.i3')) is conf2.getowner(conf2.unwrap_from_path('od1.i3')) is owners.meta
    meta.od1.i3 = 3
    conf1.od1.i3 = 2
    assert conf1.od1.i3 == 2
    assert conf2.od1.i3 == 3
    assert conf1.getowner(conf1.unwrap_from_path('od1.i3')) is owners.user
    assert conf2.getowner(conf2.unwrap_from_path('od1.i3')) is owners.meta
    meta.od1.i3 = 4
    assert conf1.od1.i3 == 2
    assert conf2.od1.i3 == 4
    assert conf1.getowner(conf1.unwrap_from_path('od1.i3')) is owners.user
    assert conf2.getowner(conf2.unwrap_from_path('od1.i3')) is owners.meta
    del(meta.od1.i3)
    assert conf1.od1.i3 == 2
    assert conf2.od1.i3 is None
    assert conf1.getowner(conf1.unwrap_from_path('od1.i3')) is owners.user
    assert conf2.getowner(conf2.unwrap_from_path('od1.i3')) is owners.default
    del(conf1.od1.i3)
    assert conf1.od1.i3 is conf2.od1.i3 is None
    assert conf1.getowner(conf1.unwrap_from_path('od1.i3')) is conf2.getowner(conf2.unwrap_from_path('od1.i3')) is owners.default


def test_default():
    meta = make_description()
    conf1, conf2 = meta.cfgimpl_get_children()
    assert conf1.od1.i2 == conf2.od1.i2 == 1
    assert conf1.getowner(conf1.unwrap_from_path('od1.i2')) is conf2.getowner(conf2.unwrap_from_path('od1.i2')) is owners.default
    meta.od1.i2 = 3
    assert conf1.od1.i2 == conf2.od1.i2 == 3
    assert conf1.getowner(conf1.unwrap_from_path('od1.i2')) is conf2.getowner(conf2.unwrap_from_path('od1.i2')) is owners.meta
    meta.od1.i2 = 3
    conf1.od1.i2 = 2
    assert conf1.od1.i2 == 2
    assert conf2.od1.i2 == 3
    assert conf1.getowner(conf1.unwrap_from_path('od1.i2')) is owners.user
    assert conf2.getowner(conf2.unwrap_from_path('od1.i2')) is owners.meta
    meta.od1.i2 = 4
    assert conf1.od1.i2 == 2
    assert conf2.od1.i2 == 4
    assert conf1.getowner(conf1.unwrap_from_path('od1.i2')) is owners.user
    assert conf2.getowner(conf2.unwrap_from_path('od1.i2')) is owners.meta
    del(meta.od1.i2)
    assert conf1.od1.i2 == 2
    assert conf2.od1.i2 == 1
    assert conf1.getowner(conf1.unwrap_from_path('od1.i2')) is owners.user
    assert conf2.getowner(conf2.unwrap_from_path('od1.i2')) is owners.default
    del(conf1.od1.i2)
    assert conf1.od1.i2 == conf2.od1.i2 == 1
    assert conf1.getowner(conf1.unwrap_from_path('od1.i2')) is conf2.getowner(conf2.unwrap_from_path('od1.i2')) is owners.default


def test_contexts():
    meta = make_description()
    conf1, conf2 = meta.cfgimpl_get_children()
    assert conf1.od1.i2 == conf2.od1.i2 == 1
    assert conf1.getowner(conf1.unwrap_from_path('od1.i2')) is conf2.getowner(conf2.unwrap_from_path('od1.i2')) is owners.default
    meta.setattrs('od1.i2', 6)
    assert meta.od1.i2 == 1
    assert conf1.od1.i2 == conf2.od1.i2 == 6
    assert conf1.getowner(conf1.unwrap_from_path('od1.i2')) is conf2.getowner(conf2.unwrap_from_path('od1.i2')) is owners.user


def test_find():
    meta = make_description()
    i2 = meta.unwrap_from_path('od1.i2')
    assert [i2] == meta.find(byname='i2')
    assert i2 == meta.find_first(byname='i2')
    assert meta.make_dict() == {'od1.i4': 2, 'od1.i1': None, 'od1.i3': None,
                                'od1.i2': 1, 'od1.i5': [2], 'od1.i6': None}


def test_meta_meta():
    meta1 = make_description()
    meta2 = MetaConfig([meta1])
    meta2.cfgimpl_get_settings().setowner(owners.meta)
    conf1, conf2 = meta1.cfgimpl_get_children()
    assert conf1.od1.i2 == conf2.od1.i2 == 1
    assert conf1.getowner(conf1.unwrap_from_path('od1.i2')) is conf2.getowner(conf2.unwrap_from_path('od1.i2')) is owners.default
    meta2.od1.i2 = 3
    assert conf1.od1.i2 == conf2.od1.i2 == 3
    assert conf1.getowner(conf1.unwrap_from_path('od1.i2')) is conf2.getowner(conf2.unwrap_from_path('od1.i2')) is owners.meta
    meta2.od1.i2 = 3
    conf1.od1.i2 = 2
    assert conf1.od1.i2 == 2
    assert conf2.od1.i2 == 3
    assert conf1.getowner(conf1.unwrap_from_path('od1.i2')) is owners.user
    assert conf2.getowner(conf2.unwrap_from_path('od1.i2')) is owners.meta
    meta2.od1.i2 = 4
    assert conf1.od1.i2 == 2
    assert conf2.od1.i2 == 4
    assert conf1.getowner(conf1.unwrap_from_path('od1.i2')) is owners.user
    assert conf2.getowner(conf2.unwrap_from_path('od1.i2')) is owners.meta
    del(meta2.od1.i2)
    assert conf1.od1.i2 == 2
    assert conf2.od1.i2 == 1
    assert conf1.getowner(conf1.unwrap_from_path('od1.i2')) is owners.user
    assert conf2.getowner(conf2.unwrap_from_path('od1.i2')) is owners.default
    del(conf1.od1.i2)
    assert conf1.od1.i2 == conf2.od1.i2 == 1
    assert conf1.getowner(conf1.unwrap_from_path('od1.i2')) is conf2.getowner(conf2.unwrap_from_path('od1.i2')) is owners.default
    meta1.od1.i2 = 6
    assert conf1.od1.i2 == conf2.od1.i2 == 6
    assert conf1.getowner(conf1.unwrap_from_path('od1.i2')) is conf2.getowner(conf2.unwrap_from_path('od1.i2')) is owners.meta


def test_meta_meta_set():
    meta1 = make_description()
    meta2 = MetaConfig([meta1])
    meta2.cfgimpl_get_settings().setowner(owners.meta)
    conf1, conf2 = meta1.cfgimpl_get_children()
    meta2.setattrs('od1.i1', 7)
    #PropertiesOptionError
    meta2.setattrs('od1.i6', 7)
    assert conf1.od1.i1 == conf2.od1.i1 == 7
    assert conf1.getowner(conf1.unwrap_from_path('od1.i1')) is conf2.getowner(conf2.unwrap_from_path('od1.i1')) is owners.user
    assert [conf1, conf2] == meta2.find_firsts(byname='i1', byvalue=7)
    conf1.od1.i1 = 8
    assert [conf1, conf2] == meta2.find_firsts(byname='i1')
    assert [conf2] == meta2.find_firsts(byname='i1', byvalue=7)
    assert [conf1] == meta2.find_firsts(byname='i1', byvalue=8)
    assert [conf1, conf2] == meta2.find_firsts(byname='i5', byvalue=2)
    raises(AttributeError, "meta2.find_firsts(byname='i1', byvalue=10)")
    raises(AttributeError, "meta2.find_firsts(byname='not', byvalue=10)")
    raises(AttributeError, "meta2.find_firsts(byname='i6')")


def test_not_meta():
    i1 = IntOption('i1', '')
    od1 = OptionDescription('od1', '', [i1])
    od2 = OptionDescription('od2', '', [od1])
    conf1 = Config(od2)
    conf2 = Config(od2)
    raises(ValueError, "GroupConfig(conf1)")
    meta = GroupConfig([conf1, conf2])
    raises(ConfigError, 'meta.od1.i1')
    conf1, conf2 = meta.cfgimpl_get_children()
    meta.setattrs('od1.i1', 7)
    assert conf1.od1.i1 == conf2.od1.i1 == 7
    assert conf1.getowner(conf1.unwrap_from_path('od1.i1')) is conf2.getowner(conf2.unwrap_from_path('od1.i1')) is owners.user


def test_meta_path():
    meta = make_description()
    assert meta._impl_path is None
    assert meta.od1._impl_path == 'od1'


def test_meta_unconsistent():
    i1 = IntOption('i1', '')
    i2 = IntOption('i2', '', default=1)
    i3 = IntOption('i3', '')
    i4 = IntOption('i4', '', default=2)
    od1 = OptionDescription('od1', '', [i1, i2, i3, i4])
    od2 = OptionDescription('od2', '', [od1])
    conf1 = Config(od2)
    conf2 = Config(od2)
    conf3 = Config(od2)
    conf4 = Config(od1)
    meta = MetaConfig([conf1, conf2])
    meta.cfgimpl_get_settings().setowner(owners.meta)
    raises(TypeError, 'MetaConfig("string")')
    raises(ValueError, "MetaConfig([conf1, conf3])")
    raises(ValueError, "MetaConfig([conf3, conf4])")
