# coding: utf-8
import autopath
from tiramisu.value import Multi
from tiramisu.option import IntOption, OptionDescription
from tiramisu.config import Config
from tiramisu.error import ConfigError

import weakref
from py.test import raises


def test_multi():
    i = IntOption('int', '', multi=True)
    o = OptionDescription('od', '', [i])
    c = Config(o)
    multi = Multi([1,2,3], weakref.ref(c), i, 'int')
    raises(ValueError, "Multi([1,2,3], c, i, 'int')")
    raises(ValueError, "Multi(multi, weakref.ref(c), i, 'int')")
    assert c is multi._getcontext()
    del(c)
    raises(ConfigError, "multi._getcontext()")
