# coding: utf-8
import autopath
#from py.test import raises

from tiramisu.config import Config
from tiramisu.option import BoolOption, OptionDescription
from tiramisu.setting import owners
from tiramisu.storage import list_sessions, delete_session


def test_non_persistent():
    b = BoolOption('b', '')
    o = OptionDescription('od', '', [b])
    Config(o, session_id='test_non_persistent')


def test_list():
    b = BoolOption('b', '')
    o = OptionDescription('od', '', [b])
    c = Config(o, session_id='test_non_persistent')
    c.cfgimpl_get_settings().remove('cache')
    assert 'test_non_persistent' in list_sessions()
    del(c)
    assert 'test_non_persistent' not in list_sessions()


def test_create_persistent():
    b = BoolOption('b', '')
    o = OptionDescription('od', '', [b])
    try:
        Config(o, session_id='test_persistent', persistent=True)
    except ValueError:
        # storage is not persistent
        pass


def test_list_sessions_persistent():
    b = BoolOption('b', '')
    o = OptionDescription('od', '', [b])
    try:
        Config(o, session_id='test_persistent', persistent=True)
    except ValueError:
        # storage is not persistent
        pass
    else:
        assert 'test_persistent' in list_sessions()


def test_delete_session_persistent():
    b = BoolOption('b', '')
    o = OptionDescription('od', '', [b])
    try:
        Config(o, session_id='test_persistent', persistent=True)
    except ValueError:
        # storage is not persistent
        pass
    else:
        assert 'test_persistent' in list_sessions()
        delete_session('test_persistent')
        assert 'test_persistent' not in list_sessions()


def test_create_persistent_retrieve():
    b = BoolOption('b', '')
    o = OptionDescription('od', '', [b])
    try:
        c = Config(o, session_id='test_persistent', persistent=True)
        c.cfgimpl_get_settings().remove('cache')
    except ValueError:
        # storage is not persistent
        pass
    else:
        assert c.b is None
        c.b = True
        assert c.b is True
        del(c)
        c = Config(o, session_id='test_persistent', persistent=True)
        c.cfgimpl_get_settings().remove('cache')
        assert c.b is True
        assert 'test_persistent' in list_sessions()
        delete_session('test_persistent')
        c = Config(o, session_id='test_persistent', persistent=True)
        c.cfgimpl_get_settings().remove('cache')
        assert c.b is None
        delete_session('test_persistent')


def test_two_persistent():
    b = BoolOption('b', '')
    o = OptionDescription('od', '', [b])
    try:
        c = Config(o, session_id='test_persistent', persistent=True)
        c.cfgimpl_get_settings().remove('cache')
    except ValueError:
        # storage is not persistent
        pass
    else:
        c2 = Config(o, session_id='test_persistent', persistent=True)
        c2.cfgimpl_get_settings().remove('cache')
        assert c.b is None
        assert c2.b is None
        c.b = False
        assert c.b is False
        assert c2.b is False
        c.b = True
        assert c.b is True
        assert c2.b is True
        delete_session('test_persistent')


def test_two_persistent_owner():
    b = BoolOption('b', '')
    o = OptionDescription('od', '', [b])
    try:
        c = Config(o, session_id='test_persistent', persistent=True)
        c.cfgimpl_get_settings().remove('cache')
    except ValueError:
        # storage is not persistent
        pass
    else:
        c2 = Config(o, session_id='test_persistent', persistent=True)
        c2.cfgimpl_get_settings().remove('cache')
        owners.addowner('persistent')
        assert c.getowner(b) == owners.default
        assert c2.getowner(b) == owners.default
        c.b = False
        assert c.getowner(b) == owners.user
        assert c2.getowner(b) == owners.user
        c.cfgimpl_get_values().setowner(b, owners.persistent)
        assert c.getowner(b) == owners.persistent
        assert c2.getowner(b) == owners.persistent
        delete_session('test_persistent')


def test_two_persistent_information():
    b = BoolOption('b', '')
    o = OptionDescription('od', '', [b])
    try:
        c = Config(o, session_id='test_persistent', persistent=True)
        c.cfgimpl_get_settings().remove('cache')
    except ValueError:
        # storage is not persistent
        pass
    else:
        c.impl_set_information('info', 'string')
        assert c.impl_get_information('info') == 'string'
        c2 = Config(o, session_id='test_persistent', persistent=True)
        c2.cfgimpl_get_settings().remove('cache')
        c2.cfgimpl_get_settings().remove('cache')
        assert c2.impl_get_information('info') == 'string'
        delete_session('test_persistent')
