# -*- coding: utf-8 -*-
"default plugin for setting: set it in a simple dictionary"
# Copyright (C) 2013 Team tiramisu (see AUTHORS for all contributors)
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by the
# Free Software Foundation, either version 3 of the License, or (at your
# option) any later version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
# details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ____________________________________________________________
from ..util import Cache


class Settings(Cache):
    __slots__ = ('_properties', '_permissives')

    def __init__(self, storage):
        # properties attribute: the name of a property enables this property
        # key is None for global properties
        self._properties = {}
        # permissive properties
        self._permissives = {}
        super(Settings, self).__init__(storage)

    # properties
    def setproperties(self, path, properties):
        self._properties[path] = properties

    def getproperties(self, path, default_properties):
        return self._properties.get(path, set(default_properties))

    def reset_all_properties(self):
        self._properties.clear()

    def reset_properties(self, path):
        try:
            del(self._properties[path])
        except KeyError:
            pass

    # permissive
    def setpermissive(self, path, permissive):
        self._permissives[path] = frozenset(permissive)

    def getpermissive(self, path=None):
        return self._permissives.get(path, frozenset())

    def get_modified_properties(self):
        """return all modified settings in a dictionary
        example: {'path1': set(['prop1', 'prop2'])}
        """
        return self._properties

    def get_modified_permissives(self):
        """return all modified permissives in a dictionary
        example: {'path1': set(['perm1', 'perm2'])}
        """
        return self._permissives
