# coding: utf-8
from autopath import do_autopath
do_autopath()

from tiramisu.setting import groups
from tiramisu.config import Config
from tiramisu.option import ChoiceOption, BoolOption, IntOption, \
    StrOption, OptionDescription
from .test_state import _diff_opts, _diff_conf
from py.test import raises


def make_description():
    numero_etab = StrOption('numero_etab', "identifiant de l'établissement")
    nom_machine = StrOption('nom_machine', "nom de la machine", default="eoleng")
    nombre_interfaces = IntOption('nombre_interfaces', "nombre d'interfaces à activer",
                                  default=1)
    activer_proxy_client = BoolOption('activer_proxy_client', "utiliser un proxy",
                                      default=False)
    mode_conteneur_actif = BoolOption('mode_conteneur_actif', "le serveur est en mode conteneur",
                                      default=False)
    mode_conteneur_actif2 = BoolOption('mode_conteneur_actif2', "le serveur est en mode conteneur2",
                                       default=False, properties=('hidden',))

    adresse_serveur_ntp = StrOption('serveur_ntp', "adresse serveur ntp", multi=True)
    time_zone = ChoiceOption('time_zone', 'fuseau horaire du serveur',
                             ('Paris', 'Londres'), 'Paris')
    wantref_option = BoolOption('wantref', 'Test requires', default=False, properties=('force_store_value',))

    ip_admin_eth0 = StrOption('ip_admin_eth0', "ip réseau autorisé")
    netmask_admin_eth0 = StrOption('netmask_admin_eth0', "masque du sous-réseau")

    master = OptionDescription('ip_admin_eth0', '', [ip_admin_eth0, netmask_admin_eth0])
    interface1 = OptionDescription('interface1', '', [master])
    interface1.impl_set_group_type(groups.family)

    general = OptionDescription('general', '', [numero_etab, nom_machine,
                                nombre_interfaces, activer_proxy_client,
                                mode_conteneur_actif, mode_conteneur_actif2,
                                adresse_serveur_ntp, time_zone, wantref_option])
    general.impl_set_group_type(groups.family)
    new = OptionDescription('new', '', [], properties=('hidden',))
    new.impl_set_group_type(groups.family)
    creole = OptionDescription('creole', 'first tiramisu configuration', [general, interface1, new])
    descr = OptionDescription('baseconfig', 'baseconifgdescr', [creole])
    return descr


def test_duplicate():
    cfg = Config(make_description())
    ncfg = cfg.duplicate()
    _diff_opts(cfg.cfgimpl_get_description(), ncfg.cfgimpl_get_description())
    _diff_conf(cfg, ncfg)
    cfg.creole.general.numero_etab = 'oui'
    raises(AssertionError, "_diff_conf(cfg, ncfg)")
    ncfg.creole.general.numero_etab = 'oui'
    _diff_conf(cfg, ncfg)


def test_duplicate_force_store_value():
    descr = make_description()
    conf = Config(descr)
    conf2 = Config(descr)
    assert conf.cfgimpl_get_values()._p_.get_modified_values() == {'creole.general.wantref': ('forced', False)}
    assert conf2.cfgimpl_get_values()._p_.get_modified_values() == {'creole.general.wantref': ('forced', False)}
    conf.creole.general.wantref = True
    assert conf.cfgimpl_get_values()._p_.get_modified_values() == {'creole.general.wantref': ('user', True)}
    assert conf2.cfgimpl_get_values()._p_.get_modified_values() == {'creole.general.wantref': ('forced', False)}
