# coding: utf-8
from autopath import do_autopath
do_autopath()

from tiramisu.value import Multi
from tiramisu.option import IntOption, StrOption, OptionDescription
from tiramisu.config import Config
from tiramisu.error import ConfigError, PropertiesOptionError
from tiramisu.setting import groups

import weakref
from py.test import raises


def test_multi():
    i = IntOption('int', '', multi=True)
    o = OptionDescription('od', '', [i])
    c = Config(o)
    multi = Multi([1, 2, 3], weakref.ref(c), i, 'int')
    raises(ValueError, "Multi([1,2,3], c, i, 'int')")
    raises(ValueError, "Multi(multi, weakref.ref(c), i, 'int')")
    assert c is multi._getcontext()
    del(c)
    raises(ConfigError, "multi._getcontext()")


def test_multi_none():
    s = StrOption('str', '', multi=True)
    o = OptionDescription('od', '', [s])
    c = Config(o)
    c.read_only()
    assert c.str == []
    c.read_write()
    c.str.append(None)
    assert c.str == [None]
    c.read_only()
    raises(PropertiesOptionError, "c.str")
    c.read_write()
    c.str = ['']
    assert c.str == ['']
    c.read_only()
    raises(PropertiesOptionError, "c.str")
