"""these tests are here to create some :class:`tiramisu.option.Option`'s
and to compare them
"""
from autopath import do_autopath
do_autopath()

from py.test import raises

from tiramisu.option import IntOption, OptionDescription
from tiramisu.config import Config


def a_func():
    return None


#def test_option_comparison():
#    "compare :class:`tiramisu.option.BoolOption`"
#    dummy1 = BoolOption('dummy1', 'doc dummy')
#    dummy2 = BoolOption('dummy2', 'doc dummy')
#    dummy3 = BoolOption('dummy1', 'doc dummy')
#    assert dummy1 != dummy2
#    assert dummy1 == dummy3


#def test_option_comparison_obj():
#    "compare :class:`tiramisu.option.IntOption`"
#    dummy1 = BoolOption('dummy1', 'doc dummy')
#    dummy2 = IntOption('dummy1', 'doc dummy')
#    assert dummy1 != dummy2


#def test_option_comparison_advanced():
#    dummy1 = BoolOption('dummy1', 'doc dummy')
#    dummy2 = BoolOption('dummy1', 'doc dummy')
#    dummy3 = BoolOption('dummy1', 'doc dummy', None)
#    dummy4 = BoolOption('dummy1', 'doc dummy', True)
#    dummy5 = BoolOption('dummy1', 'doc dummy', multi=True)
#    dummy6 = BoolOption('dummy1', 'doc dummy', properties=tuple())
#    dummy7 = BoolOption('dummy1', 'doc dummy', properties=tuple('new',))
#    assert dummy1 == dummy2
#    assert dummy1 == dummy3
#    assert dummy1 != dummy4
#    assert dummy1 != dummy5
#    assert dummy1 == dummy6
#    assert dummy1 != dummy7


def test_option_valid_name():
    IntOption('test', '')
    raises(ValueError, 'IntOption(1, "")')
    raises(ValueError, 'IntOption("1test", "")')
    IntOption("test1", "")
    raises(ValueError, 'IntOption("impl_test", "")')
    raises(ValueError, 'IntOption("_test", "")')
    raises(ValueError, 'IntOption("unwrap_from_path", "")')
    raises(ValueError, 'IntOption("   ", "")')


def test_option_with_callback():
    #no default value with callback
    raises(ValueError, "IntOption('test', '', default=1, callback=a_func)")


#def test_option_get_information():
#    description = "it's ok"
#    string = 'some informations'
#    i = IntOption('test', description)
#    raises(ValueError, "i.impl_get_information('noinfo')")
#    i.impl_set_information('info', string)
#    assert i.impl_get_information('info') == string
#    raises(ValueError, "i.impl_get_information('noinfo')")
#    assert i.impl_get_information('noinfo', 'default') == 'default'
#    assert i.impl_get_information('doc') == description
#    assert i.impl_getdoc() == description
#
#
#def test_option_get_information_config():
#    description = "it's ok"
#    string = 'some informations'
#    string
#    i = IntOption('test', description)
#    od = OptionDescription('od', '', [i])
#    Config(od)
#    raises(ValueError, "i.impl_get_information('noinfo')")
#    raises(AttributeError, "i.impl_set_information('info', string)")
##    assert i.impl_get_information('info') == string
#    raises(ValueError, "i.impl_get_information('noinfo')")
#    assert i.impl_get_information('noinfo', 'default') == 'default'
#    assert i.impl_get_information('doc') == description
#    assert i.impl_getdoc() == description
#
#
#def test_option_get_information_config2():
#    description = "it's ok"
#    string = 'some informations'
#    i = IntOption('test', description)
#    i.impl_set_information('info', string)
#    od = OptionDescription('od', '', [i])
#    Config(od)
#    raises(ValueError, "i.impl_get_information('noinfo')")
#    raises(AttributeError, "i.impl_set_information('info', 'hello')")
#    assert i.impl_get_information('info') == string
#    raises(ValueError, "i.impl_get_information('noinfo')")
#    assert i.impl_get_information('noinfo', 'default') == 'default'
#    assert i.impl_get_information('doc') == description
#    assert i.impl_getdoc() == description
#
#
#def test_optiondescription_get_information():
#    description = "it's ok"
#    string = 'some informations'
#    o = OptionDescription('test', description, [])
#    o.impl_set_information('info', string)
#    assert o.impl_get_information('info') == string
#    raises(ValueError, "o.impl_get_information('noinfo')")
#    assert o.impl_get_information('noinfo', 'default') == 'default'
#    assert o.impl_get_information('doc') == description
#    assert o.impl_getdoc() == description


def test_option_multi():
    IntOption('test', '', multi=True)
    IntOption('test', '', multi=True, default_multi=1)
    IntOption('test', '', default=[1], multi=True, default_multi=1)
    #add default_multi to not multi's option
    raises(ValueError, "IntOption('test', '', default_multi=1)")
    #unvalid default_multi
    raises(ValueError, "IntOption('test', '', multi=True, default_multi='yes')")
    #not default_multi with callback
    raises(ValueError, "IntOption('test', '', multi=True, default_multi=1, callback=a_func)")
