## coding: utf-8
from autopath import do_autopath
do_autopath()

from py.test import raises

from tiramisu.config import Config, SubConfig
from tiramisu.option import ChoiceOption, BoolOption, IntOption, FloatOption,\
    StrOption, SymLinkOption, UnicodeOption, IPOption, OptionDescription, \
    PortOption, NetworkOption, NetmaskOption, DomainnameOption, EmailOption, \
    URLOption, FilenameOption


def test_slots_option():
    c = ChoiceOption('a', '', ('a',))
    raises(AttributeError, "c.x = 1")
    c = BoolOption('a', '')
    raises(AttributeError, "c.x = 1")
    c = IntOption('a', '')
    raises(AttributeError, "c.x = 1")
    c = FloatOption('a', '')
    raises(AttributeError, "c.x = 1")
    c = StrOption('a', '')
    raises(AttributeError, "c.x = 1")
    c = SymLinkOption('b', c)
    raises(AttributeError, "c.x = 1")
    c = UnicodeOption('a', '')
    raises(AttributeError, "c.x = 1")
    c = IPOption('a', '')
    raises(AttributeError, "c.x = 1")
    c = OptionDescription('a', '', [])
    raises(AttributeError, "c.x = 1")
    c = PortOption('a', '')
    raises(AttributeError, "c.x = 1")
    c = NetworkOption('a', '')
    raises(AttributeError, "c.x = 1")
    c = NetmaskOption('a', '')
    raises(AttributeError, "c.x = 1")
    c = DomainnameOption('a', '')
    raises(AttributeError, "c.x = 1")
    c = EmailOption('a', '')
    raises(AttributeError, "c.x = 1")
    c = URLOption('a', '')
    raises(AttributeError, "c.x = 1")
    c = FilenameOption('a', '')
    raises(AttributeError, "c.x = 1")


def test_slots_option_readonly():
    a = ChoiceOption('a', '', ('a',))
    b = BoolOption('b', '')
    c = IntOption('c', '')
    d = FloatOption('d', '')
    e = StrOption('e', '')
    g = UnicodeOption('g', '')
    h = IPOption('h', '')
    i = PortOption('i', '')
    j = NetworkOption('j', '')
    k = NetmaskOption('k', '')
    l = DomainnameOption('l', '')
    o = EmailOption('o', '')
    p = URLOption('p', '')
    q = FilenameOption('q', '')
    m = OptionDescription('m', '', [a, b, c, d, e, g, h, i, j, k, l, o, p, q])
    a._requires = (((a,),),)
    b._requires = (((a,),),)
    c._requires = (((a,),),)
    d._requires = (((a,),),)
    e._requires = (((a,),),)
    g._requires = (((a,),),)
    h._requires = (((a,),),)
    i._requires = (((a,),),)
    j._requires = (((a,),),)
    k._requires = (((a,),),)
    l._requires = (((a,),),)
    m._requires = (((a,),),)
    o._requires = (((a,),),)
    p._requires = (((a,),),)
    q._requires = (((a,),),)
    Config(m)
    raises(AttributeError, "a._requires = 'a'")
    raises(AttributeError, "b._requires = 'b'")
    raises(AttributeError, "c._requires = 'c'")
    raises(AttributeError, "d._requires = 'd'")
    raises(AttributeError, "e._requires = 'e'")
    raises(AttributeError, "g._requires = 'g'")
    raises(AttributeError, "h._requires = 'h'")
    raises(AttributeError, "i._requires = 'i'")
    raises(AttributeError, "j._requires = 'j'")
    raises(AttributeError, "k._requires = 'k'")
    raises(AttributeError, "l._requires = 'l'")
    raises(AttributeError, "m._requires = 'm'")
    raises(AttributeError, "o._requires = 'o'")
    raises(AttributeError, "p._requires = 'p'")
    raises(AttributeError, "q._requires = 'q'")


def test_slots_option_readonly_name():
    a = ChoiceOption('a', '', ('a',))
    b = BoolOption('b', '')
    c = IntOption('c', '')
    d = FloatOption('d', '')
    e = StrOption('e', '')
    f = SymLinkOption('f', c)
    g = UnicodeOption('g', '')
    h = IPOption('h', '')
    i = PortOption('i', '')
    j = NetworkOption('j', '')
    k = NetmaskOption('k', '')
    l = DomainnameOption('l', '')
    o = DomainnameOption('o', '')
    p = DomainnameOption('p', '')
    q = DomainnameOption('q', '')
    m = OptionDescription('m', '', [a, b, c, d, e, f, g, h, i, j, k, l, o, p, q])
    m
    raises(AttributeError, "a._name = 'a'")
    raises(AttributeError, "b._name = 'b'")
    raises(AttributeError, "c._name = 'c'")
    raises(AttributeError, "d._name = 'd'")
    raises(AttributeError, "e._name = 'e'")
    raises(AttributeError, "f._name = 'f'")
    raises(AttributeError, "g._name = 'g'")
    raises(AttributeError, "h._name = 'h'")
    raises(AttributeError, "i._name = 'i'")
    raises(AttributeError, "j._name = 'j'")
    raises(AttributeError, "k._name = 'k'")
    raises(AttributeError, "l._name = 'l'")
    raises(AttributeError, "m._name = 'm'")
    raises(AttributeError, "o._name = 'o'")
    raises(AttributeError, "p._name = 'p'")
    raises(AttributeError, "q._name = 'q'")


#def test_slots_description():
#    # __slots__ for OptionDescription should be complete for __getattr__
#    slots = set()
#    for subclass in OptionDescription.__mro__:
#        if subclass is not object:
#            slots.update(subclass.__slots__)
#    assert slots == set(OptionDescription.__slots__)


def test_slots_config():
    od1 = OptionDescription('a', '', [])
    od2 = OptionDescription('a', '', [od1])
    c = Config(od2)
    raises(AttributeError, "c.x = 1")
    raises(AttributeError, "c.cfgimpl_x = 1")
    sc = c.a
    assert isinstance(sc, SubConfig)
    raises(AttributeError, "sc.x = 1")
    raises(AttributeError, "sc.cfgimpl_x = 1")


def test_slots_setting():
    od1 = OptionDescription('a', '', [])
    od2 = OptionDescription('a', '', [od1])
    c = Config(od2)
    s = c.cfgimpl_get_settings()
    s
    raises(AttributeError, "s.x = 1")


def test_slots_value():
    od1 = OptionDescription('a', '', [])
    od2 = OptionDescription('a', '', [od1])
    c = Config(od2)
    v = c.cfgimpl_get_values()
    v
    raises(AttributeError, "v.x = 1")
