# coding: utf-8
from autopath import do_autopath
do_autopath()

from tiramisu.option import BoolOption, StrOption, SymLinkOption, \
    OptionDescription
from tiramisu.config import Config
from tiramisu.error import PropertiesOptionError
from tiramisu.setting import groups, owners

from py.test import raises


#____________________________________________________________
def test_symlink_option():
    boolopt = BoolOption("b", "", default=False)
    linkopt = SymLinkOption("c", boolopt)
    descr = OptionDescription("opt", "",
                              [linkopt, OptionDescription("s1", "", [boolopt])])
    config = Config(descr)
    assert config.s1.b is False
    setattr(config, "s1.b", True)
    setattr(config, "s1.b", False)
    assert config.s1.b is False
    assert config.c is False
    config.c = True
    assert config.s1.b is True
    assert config.c is True
    config.c = False
    assert config.s1.b is False
    assert config.c is False


def test_symlink_requires():
    boolopt = BoolOption('b', '', default=True)
    stropt = StrOption('s', '', requires=[{'option': boolopt,
                                           'expected': False,
                                           'action': 'disabled'}])
    linkopt = SymLinkOption("c", stropt)
    descr = OptionDescription('opt', '', [boolopt, stropt, linkopt])
    config = Config(descr)
    config.read_write()
    assert config.b is True
    assert config.s is None
    assert config.c is None
    config.b = False
    #
    props = []
    try:
        config.s
    except PropertiesOptionError as err:
        props = err.proptype
    assert props == ['disabled']
    #
    props = []
    try:
        config.c
    except PropertiesOptionError as err:
        props = err.proptype
    assert props == ['disabled']


def test_symlink_multi():
    boolopt = BoolOption("b", "", default=[False], multi=True)
    linkopt = SymLinkOption("c", boolopt)
    descr = OptionDescription("opt", "",
                              [linkopt, OptionDescription("s1", "", [boolopt])])
    config = Config(descr)
    assert config.s1.b == [False]
    assert config.c == [False]
    config.c = [True]
    assert config.s1.b == [True]
    assert config.c == [True]
    config.c = [False]
    assert config.s1.b == [False]
    assert config.c == [False]
    config.c.append(True)
    assert config.s1.b == [False, True]
    assert config.c == [False, True]
    assert boolopt.impl_is_multi() is True
    assert linkopt.impl_is_multi() is True


def test_symlink_owner():
    boolopt = BoolOption("b", "", default=False)
    linkopt = SymLinkOption("c", boolopt)
    descr = OptionDescription("opt", "",
                              [linkopt, OptionDescription("s1", "", [boolopt])])
    config = Config(descr)
    assert config.getowner(boolopt) == owners.default
    assert config.getowner(linkopt) == owners.default
    config.c = True
    assert config.getowner(boolopt) != owners.default
    assert config.getowner(linkopt) != owners.default


def test_symlink_get_information():
    boolopt = BoolOption("b", "", default=False)
    linkopt = SymLinkOption("c", boolopt)
    boolopt.impl_set_information('test', 'test')
    assert boolopt.impl_get_information('test') == 'test'
    assert linkopt.impl_get_information('test') == 'test'
    boolopt.impl_set_information('test', 'test2')
    assert boolopt.impl_get_information('test') == 'test2'
    assert linkopt.impl_get_information('test') == 'test2'


def test_symlink_master():
    a = StrOption('a', "", multi=True)
    ip_admin_eth0 = SymLinkOption('ip_admin_eth0', a)
    netmask_admin_eth0 = StrOption('netmask_admin_eth0', "", multi=True)
    interface1 = OptionDescription('ip_admin_eth0', '', [ip_admin_eth0, netmask_admin_eth0])
    interface1
    raises(ValueError, 'interface1.impl_set_group_type(groups.master)')


def test_symlink_slaves():
    a = StrOption('a', "", multi=True)
    ip_admin_eth0 = StrOption('ip_admin_eth0', "ip réseau autorisé", multi=True)
    netmask_admin_eth0 = SymLinkOption('netmask_admin_eth0', a)
    interface1 = OptionDescription('ip_admin_eth0', '', [ip_admin_eth0, netmask_admin_eth0])
    interface1
    raises(ValueError, 'interface1.impl_set_group_type(groups.master)')
