# -*- coding: utf-8 -*-
"default plugin for value: set it in a simple dictionary"
# Copyright (C) 2013-2014 Team tiramisu (see AUTHORS for all contributors)
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by the
# Free Software Foundation, either version 3 of the License, or (at your
# option) any later version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
# details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ____________________________________________________________
from ..util import Cache
from ...setting import undefined
from ...i18n import _


class Values(Cache):
    __slots__ = ('_values', '_informations', '__weakref__')

    def __init__(self, storage):
        """init plugin means create values storage
        """
        #(('path1',), (index1,), (value1,), ('owner1'))
        self._values = (tuple(), tuple(), tuple(), tuple())
        self._informations = {}
        # should init cache too
        super(Values, self).__init__(storage)

    def getsession(self):
        pass

    def delsession(self, session):
        pass

    def _setvalue_info(self, nb, idx, value, values, index, vidx):
        lst = list(self._values[nb])
        if idx is None:
            if index is None or nb == 0:
                lst.append(value)
            else:
                lst.append((value,))
        else:
            if index is None or nb == 0:
                lst[idx] = value
            else:
                if nb == 1:
                    if index in lst[idx]:
                        vidx = lst[idx].index(index)
                    else:
                        vidx = None
                if vidx is None:
                    tval = list(lst[idx])
                    tval.append(value)
                    lst[idx] = tuple(tval)
                elif nb != 1:
                    tval = list(lst[idx])
                    tval[vidx] = value
                    lst[idx] = tuple(tval)
                lst[idx] = tuple(lst[idx])
        values.append(tuple(lst))
        return vidx
    # value
    def setvalue(self, path, value, owner, index, session):
        """set value for a path
        a specified value must be associated to an owner
        """
        values = []
        vidx = None

        if path in self._values[0]:
            idx = self._values[0].index(path)
        else:
            idx = None
        vidx = self._setvalue_info(0, idx, path, values, index, vidx)
        vidx = self._setvalue_info(1, idx, index, values, index, vidx)
        if isinstance(value, list):
            value = tuple(value)
        vidx = self._setvalue_info(2, idx, value, values, index, vidx)
        if isinstance(value, list):
            value = tuple(value)
        self._setvalue_info(3, idx, owner, values, index, vidx)
        self._values = tuple(values)

    def getvalue(self, path, session, index=None):
        """get value for a path
        return: only value, not the owner
        """
        return self._getvalue(path, 2, index)

    def hasvalue(self, path, index=None):
        """if path has a value
        return: boolean
        """
        return path in self._values[0]

    def resetvalue(self, path, session):
        """remove value means delete value in storage
        """
        def _resetvalue(nb):
            lst = list(self._values[nb])
            lst.pop(idx)
            values.append(tuple(lst))
        values = []
        if path in self._values[0]:
            idx = self._values[0].index(path)
            _resetvalue(0)
            _resetvalue(1)
            _resetvalue(2)
            _resetvalue(3)
            self._values = tuple(values)

    def get_modified_values(self):
        """return all values in a dictionary
        example: {'path1': (owner, 'value1'), 'path2': (owner, 'value2')}
        """
        values = {}
        for idx, path in enumerate(self._values[0]):
            indexes = self._values[1][idx]
            value = self._values[2][idx]
            owner = self._values[3][idx]
            if indexes is not None:
                val = {}
                own = {}
                for cpt, index in enumerate(indexes):
                    val[str(index)] = value[cpt]
                    own[str(index)] = owner[cpt]
                value = val
                owner = own
            values[path] = (owner, value)
        return values

    # owner
    def setowner(self, path, owner, session, index=None):
        """change owner for a path
        """
        idx = self._values[0].index(path)
        if index is None:
            vidx = None
        else:
            vidx = self._values[1][idx].index(index)
        values = []
        self._setvalue_info(3, idx, owner, values, index, vidx)
        lst = list(self._values)
        lst[3] = tuple(values[0])
        self._values = tuple(lst)

    def get_max_length(self, path, session):
        if path in self._values[0]:
            idx = self._values[0].index(path)
        else:
            return 0
        return max(self._values[1][idx]) + 1

    def getowner(self, path, default, session, index=None, only_default=False):
        """get owner for a path
        return: owner object
        """
        if index is None:
            if only_default:
                if path in self._values[0]:
                    return undefined
                else:
                    return default
            val = self._getvalue(path, 3, index)
            if val is undefined:
                return default
            return val
        else:
            value = self._getvalue(path, 3, index)
            if value is undefined:
                return default
            else:
                return value

    def _getvalue(self, path, nb, index):
        """
        _values == ((path1, path2), ((idx1_1, idx1_2), None), ((value1_1, value1_2), value2), ((owner1_1, owner1_2), owner2))
        """
        if path in self._values[0]:
            idx = self._values[0].index(path)
            if isinstance(self._values[1][idx], tuple):
                if index is None:
                    raise ValueError('index is mandatory')
            elif index is not None:
                raise ValueError('index is forbidden')

            if self._values[1][idx] is None:
                if index is None:
                    value = self._values[nb][idx]
                else:
                    value = self._values[nb][idx][index]
            else:
                if index is not None:
                    if index in self._values[1][idx]:
                        subidx = self._values[1][idx].index(index)
                        value = self._values[nb][idx][subidx]
                    else:
                        value = undefined
                else:
                    value = []
                    for i in xrange(0, max(self._values[1][idx])):
                        if i in self._values[1][idx]:
                            value.append(self._values[nb][idx][self._values[1][idx].index(i)])
                        else:
                            value.append(undefined)
        else:
            value = undefined
        if isinstance(value, tuple):
            value = list(value)
        return value

    def set_information(self, key, value):
        """updates the information's attribute
        (which is a dictionary)

        :param key: information's key (ex: "help", "doc"
        :param value: information's value (ex: "the help string")
        """
        self._informations[key] = value

    def get_information(self, key, default):
        """retrieves one information's item

        :param key: the item string (ex: "help")
        """
        value = self._informations.get(key, default)
        if value is undefined:
            raise ValueError(_("information's item"
                               " not found: {0}").format(key))
        return value

    def del_information(self, key, raises):
        if key in self._informations:
            del(self._informations[key])
        else:
            if raises:
                raise ValueError(_("information's item not found {0}").format(key))

    def exportation(self, session, fake=False):
        return self._values

    def importation(self, export):
        self._values = export

def delete_session(session_id, session):
    raise ValueError(_('a dictionary cannot be persistent'))
