# coding: utf-8
from .autopath import do_autopath
do_autopath()

from py.test import raises
from tiramisu.config import Config
from tiramisu.option import IntOption, StrOption, UnicodeOption, OptionDescription, SymLinkOption
from tiramisu.error import PropertiesOptionError, ConfigError
from tiramisu.setting import groups
from tiramisu.storage import delete_session


def make_description():
    stroption = StrOption('str', 'Test string option', default="abc",
                          properties=('mandatory', ))
    stroption1 = StrOption('str1', 'Test string option',
                           properties=('mandatory', ))
    stroption2 = UnicodeOption('unicode2', 'Test string option',
                               properties=('mandatory', ))
    stroption3 = StrOption('str3', 'Test string option', multi=True,
                           properties=('mandatory', ))
    stroption4 = StrOption('str4', 'Test string option', multi=True,
                           properties=('mandatory', ), allow_empty_list=True)
    descr = OptionDescription('tiram', '', [stroption, stroption1, stroption2, stroption3, stroption4])
    return descr


def return_value(value):
    return value


def make_description2():
    stroption = StrOption('str', 'Test string option', default="abc",
                          properties=('mandatory', ))
    stroption1 = StrOption('str1', 'Test string option',
                           properties=('mandatory', ))
    stroption2 = SymLinkOption('unicode2', stroption1)
    stroption3 = StrOption('str3', 'Test string option', multi=True,
                           properties=('mandatory', ))
    unicode1 = UnicodeOption('unicode1', 'Test string option', callback=return_value, callback_params={'': ((stroption, False),)},  properties=('mandatory', ))
    descr = OptionDescription('tiram', '', [stroption, stroption1, stroption2, stroption3, unicode1])
    return descr


def make_description_sym():
    stroption = StrOption('str', 'Test string option', default="abc",
                          properties=('mandatory', ))
    stroption1 = StrOption('str1', 'Test string option',
                           properties=('mandatory', ))
    stroption2 = SymLinkOption('unicode2', stroption1)
    stroption3 = StrOption('str3', 'Test string option', multi=True,
                           properties=('mandatory', ))
    descr = OptionDescription('tiram', '', [stroption, stroption1, stroption2, stroption3])
    return descr


def make_description3():
    stroption = StrOption('str', 'Test string option', default="abc",
                          properties=('mandatory', ))
    stroption1 = StrOption('str1', 'Test string option',
                           properties=('mandatory', ))
    stroption2 = SymLinkOption('unicode2', stroption1)
    stroption3 = StrOption('str3', 'Test string option', multi=True,
                           properties=('mandatory', ))
    unicode1 = UnicodeOption('unicode1', 'Test string option', callback=return_value, callback_params={'': ((stroption, False),)},  properties=('mandatory', ))
    int1 = IntOption('int1', '', callback=return_value, callback_params={'': ((stroption, False),)},  properties=('mandatory', ))
    descr = OptionDescription('tiram', '', [stroption, stroption1, stroption2, stroption3, unicode1, int1])
    return descr


def make_description4():
    stroption = StrOption('str', 'Test string option', default="abc",
                          properties=('mandatory', ))
    stroption1 = StrOption('str1', 'Test string option',
                           properties=('mandatory', ))
    stroption2 = UnicodeOption('unicode2', 'Test string option',
                               properties=('mandatory', ))
    stroption3 = StrOption('str3', 'Test string option', multi=True, requires=[{'option': stroption, 'expected': 'yes', 'action': 'mandatory', 'transitive': False}])
    descr = OptionDescription('tiram', '', [stroption, stroption1, stroption2, stroption3])
    return descr


def test_mandatory_ro():
    descr = make_description()
    config = Config(descr, session_id='man001')
    config.read_only()
    prop = []
    try:
        config.str1
    except PropertiesOptionError as err:
        prop = err.proptype
    assert 'mandatory' in prop
    config.read_write()
    config.str1 = 'yes'
    config.read_only()
    assert config.str1 == 'yes'
    try:
        delete_session('config', config.impl_getsessionid())
    except ValueError:
        pass
    del(config)


def test_mandatory_rw():
    descr = make_description()
    config = Config(descr, session_id='man002')
    config.read_write()
    #not mandatory in rw
    config.str1
    config.str1 = 'yes'
    assert config.str1 == 'yes'
    try:
        delete_session('config', config.impl_getsessionid())
    except ValueError:
        pass
    del(config)


def test_mandatory_default():
    descr = make_description()
    config = Config(descr, session_id='man003')
    config.read_only()
    #not mandatory in rw
    config.str
    config.read_write()
    config.str = 'yes'
    config.read_only()
    config.str
    config.read_write()
    config.str = None
    config.read_only()
    prop = []
    try:
        config.str
    except PropertiesOptionError as err:
        prop = err.proptype
    assert 'mandatory' in prop
    try:
        delete_session('config', config.impl_getsessionid())
    except ValueError:
        pass
    del(config)


def test_mandatory_delete():
    descr = make_description()
    config = Config(descr, session_id='man004')
    config.read_only()
    config.str
    try:
        config.str1
    except PropertiesOptionError as err:
        prop = err.proptype
    assert 'mandatory' in prop
    config.read_write()
    config.str1 = 'yes'
    config.read_only()
    assert config.str1 == 'yes'
    config.cfgimpl_get_settings().remove('frozen')
    prop = []
    try:
        del(config.str1)
    except PropertiesOptionError as err:
        prop = err.proptype
    assert 'mandatory' in prop
    del(config.str)
    assert config.str1 == 'yes'
    try:
        delete_session('config', config.impl_getsessionid())
    except ValueError:
        pass
    del(config)


#valeur vide : None, '', u'', ...
def test_mandatory_none():
    descr = make_description()
    config = Config(descr, session_id='man005')
    config.str1 = None
    assert config.getowner(config.unwrap_from_path('str1')) == 'user'
    config.read_only()
    prop = []
    try:
        config.str1
    except PropertiesOptionError as err:
        prop = err.proptype
    assert 'mandatory' in prop
    try:
        delete_session('config', config.impl_getsessionid())
    except ValueError:
        pass
    del(config)


def test_mandatory_empty():
    descr = make_description()
    config = Config(descr, session_id='man006')
    config.str1 = ''
    assert config.getowner(config.unwrap_from_path('str1')) == 'user'
    config.read_only()
    prop = []
    try:
        config.str1
    except PropertiesOptionError as err:
        prop = err.proptype
    assert 'mandatory' in prop
    try:
        delete_session('config', config.impl_getsessionid())
    except ValueError:
        pass
    del(config)


def test_mandatory_multi_none():
    descr = make_description()
    config = Config(descr, session_id='man007')
    config.str3 = [None]
    assert config.getowner(config.unwrap_from_path('str3')) == 'user'
    config.read_only()
    prop = []
    try:
        config.str3
    except PropertiesOptionError as err:
        prop = err.proptype
    assert 'mandatory' in prop
    config.read_write()
    config.str3 = ['yes', None]
    assert config.getowner(config.unwrap_from_path('str3')) == 'user'
    config.read_only()
    prop = []
    try:
        config.str3
    except PropertiesOptionError as err:
        prop = err.proptype
    assert 'mandatory' in prop
    try:
        delete_session('config', config.impl_getsessionid())
    except ValueError:
        pass
    del(config)


def test_mandatory_multi_empty():
    descr = make_description()
    config = Config(descr, session_id='man008')
    config.str3 = []
    assert config.getowner(config.unwrap_from_path('str3')) == 'user'
    config.read_only()
    prop = []
    try:
        config.str3
    except PropertiesOptionError as err:
        prop = err.proptype
    assert 'mandatory' in prop
    #
    config.read_write()
    config.str3 = ['']
    assert config.getowner(config.unwrap_from_path('str3')) == 'user'
    config.read_only()
    prop = []
    try:
        config.str3
    except PropertiesOptionError as err:
        prop = err.proptype
    assert 'mandatory' in prop
    #
    config.read_write()
    config.str3 = ['yes', '']
    assert config.getowner(config.unwrap_from_path('str3')) == 'user'
    config.read_only()
    prop = []
    try:
        config.str3
    except PropertiesOptionError as err:
        prop = err.proptype
    assert 'mandatory' in prop
    try:
        delete_session('config', config.impl_getsessionid())
    except ValueError:
        pass
    del(config)


def test_mandatory_multi_empty_allow_empty_list():
    descr = make_description()
    config = Config(descr, session_id='man009')
    config.str4 = []
    assert config.getowner(config.unwrap_from_path('str4')) == 'user'
    config.read_only()
    prop = []
    config.str4
    #
    config.read_write()
    config.str4 = ['']
    assert config.getowner(config.unwrap_from_path('str4')) == 'user'
    config.read_only()
    prop = []
    try:
        config.str4
    except PropertiesOptionError as err:
        prop = err.proptype
    assert 'mandatory' in prop
    #
    config.read_write()
    config.str4 = ['yes', '']
    assert config.getowner(config.unwrap_from_path('str4')) == 'user'
    config.read_only()
    prop = []
    try:
        config.str4
    except PropertiesOptionError as err:
        prop = err.proptype
    assert 'mandatory' in prop
    try:
        delete_session('config', config.impl_getsessionid())
    except ValueError:
        pass
    del(config)


def test_mandatory_multi_append():
    descr = make_description()
    config = Config(descr, session_id='man010')
    config.str3 = ['yes']
    config.read_write()
    config.str3.append(None)
    try:
        delete_session('config', config.impl_getsessionid())
    except ValueError:
        pass
    del(config)


def test_mandatory_disabled():
    descr = make_description()
    config = Config(descr, session_id='man011')
    setting = config.cfgimpl_get_settings()
    config.str1
    config.read_only()
    prop = []
    try:
        config.str1
    except PropertiesOptionError as err:
        prop = err.proptype
    assert prop == ['mandatory']
    setting[descr.str1].append('disabled')
    prop = []
    try:
        config.str1
    except PropertiesOptionError as err:
        prop = err.proptype
    assert set(prop) == set(['disabled', 'mandatory'])
    try:
        delete_session('config', config.impl_getsessionid())
    except ValueError:
        pass
    del(config)


def test_mandatory_unicode():
    descr = make_description()
    config = Config(descr, session_id='man012')
    config.unicode2
    config.read_only()
    prop = []
    try:
        config.unicode2
    except PropertiesOptionError as err:
        prop = err.proptype
    assert prop == ['mandatory']
    config.read_write()
    config.unicode2 = u''
    config.read_only()
    prop = []
    try:
        config.unicode2
    except PropertiesOptionError as err:
        prop = err.proptype
    assert prop == ['mandatory']
    try:
        delete_session('config', config.impl_getsessionid())
    except ValueError:
        pass
    del(config)


def test_mandatory_warnings_ro():
    descr = make_description()
    config = Config(descr, session_id='man013')
    config.str = ''
    config.read_only()
    proc = []
    try:
        config.str
    except PropertiesOptionError as err:
        proc = err.proptype
    assert proc == ['mandatory']
    assert list(config.cfgimpl_get_values().mandatory_warnings()) == ['str', 'str1', 'unicode2', 'str3']
    config.read_write()
    config.str = 'a'
    config.read_only()
    assert list(config.cfgimpl_get_values().mandatory_warnings()) == ['str1', 'unicode2', 'str3']
    try:
        delete_session('config', config.impl_getsessionid())
    except ValueError:
        pass
    del(config)


def test_mandatory_warnings_rw():
    descr = make_description()
    config = Config(descr, session_id='man100')
    config.str = ''
    config.read_write()
    config.str
    assert list(config.cfgimpl_get_values().mandatory_warnings()) == ['str', 'str1', 'unicode2', 'str3']
    config.str = 'a'
    assert list(config.cfgimpl_get_values().mandatory_warnings()) == ['str1', 'unicode2', 'str3']
    try:
        delete_session('config', 'man100')
    except ValueError:
        pass
    del(config)


def test_mandatory_warnings_disabled():
    descr = make_description()
    config = Config(descr, session_id='man101')
    config.str = ''
    setting = config.cfgimpl_get_settings()
    config.read_write()
    config.str
    assert list(config.cfgimpl_get_values().mandatory_warnings()) == ['str', 'str1', 'unicode2', 'str3']
    setting[descr.str].append('disabled')
    assert list(config.cfgimpl_get_values().mandatory_warnings()) == ['str1', 'unicode2', 'str3']
    try:
        delete_session('config', 'man101')
    except ValueError:
        pass
    del(config)


def test_mandatory_warnings_hidden():
    descr = make_description()
    config = Config(descr, session_id='man102')
    config.str = ''
    setting = config.cfgimpl_get_settings()
    config.read_write()
    config.cfgimpl_get_settings().setpermissive(('hidden',))
    config.str
    assert list(config.cfgimpl_get_values().mandatory_warnings()) == ['str', 'str1', 'unicode2', 'str3']
    setting[descr.str].append('hidden')
    assert list(config.cfgimpl_get_values().mandatory_warnings()) == ['str', 'str1', 'unicode2', 'str3']
    try:
        delete_session('config', 'man102')
    except ValueError:
        pass
    del(config)


def test_mandatory_warnings_frozen():
    descr = make_description()
    config = Config(descr, session_id='man103')
    config.str = ''
    setting = config.cfgimpl_get_settings()
    config.read_write()
    config.str
    assert list(config.cfgimpl_get_values().mandatory_warnings()) == ['str', 'str1', 'unicode2', 'str3']
    setting[descr.str].append('frozen')
    config.read_only()
    assert list(config.cfgimpl_get_values().mandatory_warnings()) == ['str', 'str1', 'unicode2', 'str3']
    try:
        delete_session('config', 'man103')
    except ValueError:
        pass
    del(config)


def test_mandatory_master():
    ip_admin_eth0 = StrOption('ip_admin_eth0', "ip réseau autorisé", multi=True,
                              properties=('mandatory', ))
    netmask_admin_eth0 = StrOption('netmask_admin_eth0', "masque du sous-réseau",
                                   multi=True)
    interface1 = OptionDescription('ip_admin_eth0', '', [ip_admin_eth0, netmask_admin_eth0])
    interface1.impl_set_group_type(groups.master)
    o = OptionDescription('o', '', [interface1])
    config = Config(o, session_id='man104')
    config.read_only()
    raises(PropertiesOptionError, 'config.ip_admin_eth0.ip_admin_eth0')
    raises(PropertiesOptionError, 'config.ip_admin_eth0.netmask_admin_eth0')
    try:
        delete_session('config', 'man104')
    except ValueError:
        pass
    del(config)


def test_mandatory_warnings_master():
    ip_admin_eth0 = StrOption('ip_admin_eth0', "ip réseau autorisé", multi=True,
                              properties=('mandatory', ))
    netmask_admin_eth0 = StrOption('netmask_admin_eth0', "masque du sous-réseau",
                                   multi=True)
    interface1 = OptionDescription('ip_admin_eth0', '', [ip_admin_eth0, netmask_admin_eth0])
    interface1.impl_set_group_type(groups.master)
    o = OptionDescription('o', '', [interface1])
    config = Config(o, session_id='man105')
    assert list(config.cfgimpl_get_values().mandatory_warnings()) == ['ip_admin_eth0.ip_admin_eth0']
    try:
        delete_session('config', 'man105')
    except ValueError:
        pass
    del(config)


def test_mandatory_master_empty():
    ip_admin_eth0 = StrOption('ip_admin_eth0', "ip réseau autorisé", multi=True)
    netmask_admin_eth0 = StrOption('netmask_admin_eth0', "masque du sous-réseau",
                                   multi=True)
    interface1 = OptionDescription('ip_admin_eth0', '', [ip_admin_eth0, netmask_admin_eth0])
    interface1.impl_set_group_type(groups.master)
    o = OptionDescription('o', '', [interface1])
    config = Config(o, session_id='man106')
    config.read_write()
    assert config.ip_admin_eth0.ip_admin_eth0 == []
    assert config.ip_admin_eth0.netmask_admin_eth0 == []
    #
    config.ip_admin_eth0.ip_admin_eth0.append()
    assert config.ip_admin_eth0.ip_admin_eth0 == [None]
    assert config.ip_admin_eth0.netmask_admin_eth0 == [None]
    config.read_only()
    raises(PropertiesOptionError, "config.ip_admin_eth0.ip_admin_eth0")
    raises(PropertiesOptionError, "config.ip_admin_eth0.netmask_admin_eth0")
    config.read_write()
    del(config.ip_admin_eth0.ip_admin_eth0)
    del(config.ip_admin_eth0.netmask_admin_eth0)
    assert config.ip_admin_eth0.ip_admin_eth0 == []
    assert config.ip_admin_eth0.netmask_admin_eth0 == []
    #
    config.ip_admin_eth0.ip_admin_eth0.append('')
    assert config.ip_admin_eth0.ip_admin_eth0 == ['']
    assert config.ip_admin_eth0.netmask_admin_eth0 == [None]
    config.read_only()
    raises(PropertiesOptionError, "config.ip_admin_eth0.ip_admin_eth0")
    raises(PropertiesOptionError, "config.ip_admin_eth0.netmask_admin_eth0")
    config.read_write()
    #
    config.read_write()
    config.ip_admin_eth0.ip_admin_eth0 = ['ip']
    config.read_only()
    assert config.ip_admin_eth0.ip_admin_eth0 == ['ip']
    assert config.ip_admin_eth0.netmask_admin_eth0 == [None]
    #
    config.read_write()
    config.ip_admin_eth0.netmask_admin_eth0 = ['ip2']
    config.read_only()
    raises(PropertiesOptionError, "del(config.ip_admin_eth0.netmask_admin_eth0)")
    raises(PropertiesOptionError, "del(config.ip_admin_eth0.ip_admin_eth0)")
    config.read_write()
    del(config.ip_admin_eth0.netmask_admin_eth0)
    del(config.ip_admin_eth0.ip_admin_eth0)
    try:
        delete_session('config', 'man106')
    except ValueError:
        pass
    del(config)


def test_mandatory_warnings_master_empty():
    ip_admin_eth0 = StrOption('ip_admin_eth0', "ip réseau autorisé", multi=True)
    netmask_admin_eth0 = StrOption('netmask_admin_eth0', "masque du sous-réseau",
                                   multi=True)
    interface1 = OptionDescription('ip_admin_eth0', '', [ip_admin_eth0, netmask_admin_eth0])
    interface1.impl_set_group_type(groups.master)
    o = OptionDescription('o', '', [interface1])
    config = Config(o, session_id='man107')
    config.read_write()
    config.ip_admin_eth0.ip_admin_eth0.append()
    assert config.ip_admin_eth0.ip_admin_eth0 == [None]
    assert config.ip_admin_eth0.netmask_admin_eth0 == [None]
    assert list(config.cfgimpl_get_values().mandatory_warnings()) == ['ip_admin_eth0.ip_admin_eth0']
    del(config.ip_admin_eth0.ip_admin_eth0)
    del(config.ip_admin_eth0.netmask_admin_eth0)
    #
    config.ip_admin_eth0.ip_admin_eth0.append('')
    assert config.ip_admin_eth0.ip_admin_eth0 == ['']
    assert config.ip_admin_eth0.netmask_admin_eth0 == [None]
    assert list(config.cfgimpl_get_values().mandatory_warnings()) == ['ip_admin_eth0.ip_admin_eth0']
    #
    config.read_write()
    config.ip_admin_eth0.ip_admin_eth0 = ['ip']
    assert list(config.cfgimpl_get_values().mandatory_warnings()) == []
    try:
        delete_session('config', 'man107')
    except ValueError:
        pass
    del(config)


def test_mandatory_slave():
    ip_admin_eth0 = StrOption('ip_admin_eth0', "ip réseau autorisé", multi=True)
    netmask_admin_eth0 = StrOption('netmask_admin_eth0', "masque du sous-réseau",
                                   multi=True, properties=('mandatory', ))
    interface1 = OptionDescription('ip_admin_eth0', '', [ip_admin_eth0, netmask_admin_eth0])
    interface1.impl_set_group_type(groups.master)
    o = OptionDescription('o', '', [interface1])
    config = Config(o, session_id='man108')
    config.read_only()
    assert config.ip_admin_eth0.ip_admin_eth0 == []
    assert config.ip_admin_eth0.netmask_admin_eth0 == []
    #
    config.read_write()
    config.ip_admin_eth0.ip_admin_eth0.append('ip')
    config.read_only()
    assert config.ip_admin_eth0.ip_admin_eth0 == ['ip']
    assert len(config.ip_admin_eth0.netmask_admin_eth0) == 1
    raises(PropertiesOptionError, 'config.ip_admin_eth0.netmask_admin_eth0[0]')
    #
    config.read_write()
    config.ip_admin_eth0.netmask_admin_eth0 = ['']
    config.read_only()
    assert config.ip_admin_eth0.ip_admin_eth0 == ['ip']
    assert len(config.ip_admin_eth0.netmask_admin_eth0) == 1
    raises(PropertiesOptionError, 'config.ip_admin_eth0.netmask_admin_eth0[0]')
    #
    config.read_write()
    config.ip_admin_eth0.netmask_admin_eth0 = ['ip']
    config.read_only()
    assert config.ip_admin_eth0.ip_admin_eth0 == ['ip']
    assert config.ip_admin_eth0.netmask_admin_eth0 == ['ip']
    try:
        delete_session('config', 'man108')
    except ValueError:
        pass
    del(config)


def test_mandatory_warnings_slave():
    ip_admin_eth0 = StrOption('ip_admin_eth0', "ip réseau autorisé", multi=True)
    netmask_admin_eth0 = StrOption('netmask_admin_eth0', "masque du sous-réseau",
                                   multi=True, properties=('mandatory', ))
    interface1 = OptionDescription('ip_admin_eth0', '', [ip_admin_eth0, netmask_admin_eth0])
    interface1.impl_set_group_type(groups.master)
    o = OptionDescription('o', '', [interface1])
    config = Config(o, session_id='man109')
    config.read_only()
    assert config.ip_admin_eth0.ip_admin_eth0 == []
    assert config.ip_admin_eth0.netmask_admin_eth0 == []
    #
    config.read_write()
    assert list(config.cfgimpl_get_values().mandatory_warnings()) == []
    config.ip_admin_eth0.ip_admin_eth0.append('ip')
    assert list(config.cfgimpl_get_values().mandatory_warnings()) == ['ip_admin_eth0.netmask_admin_eth0']
    try:
        delete_session('config', 'man109')
    except ValueError:
        pass
    del(config)


def test_mandatory_warnings_symlink():
    descr = make_description_sym()
    config = Config(descr, session_id='man110')
    config.str = ''
    setting = config.cfgimpl_get_settings()
    config.read_write()
    config.str
    assert list(config.cfgimpl_get_values().mandatory_warnings()) == ['str', 'str1', 'str3']
    setting[descr.str].append('frozen')
    config.read_only()
    assert list(config.cfgimpl_get_values().mandatory_warnings()) == ['str', 'str1', 'str3']
    try:
        delete_session('config', 'man110')
    except ValueError:
        pass
    del(config)


def test_mandatory_warnings_validate():
    descr = make_description3()
    config = Config(descr, session_id='man111')
    config.str = ''
    raises(ValueError, "list(config.cfgimpl_get_values().mandatory_warnings())")
    config.str = 'test'
    raises(ValueError, "list(config.cfgimpl_get_values().mandatory_warnings())")
    try:
        delete_session('config', 'man111')
    except ValueError:
        pass
    del(config)


def test_mandatory_warnings_validate_empty():
    descr = make_description2()
    config = Config(descr, session_id='man112')
    config.str = ''
    config.read_only()
    assert list(config.cfgimpl_get_values().mandatory_warnings()) == ['str', 'str1', 'str3', 'unicode1']
    try:
        delete_session('config', 'man112')
    except ValueError:
        pass
    del(config)


def test_mandatory_warnings_requires():
    descr = make_description4()
    config = Config(descr, session_id='man113')
    config.str = ''
    config.read_write()
    config.str
    assert list(config.cfgimpl_get_values().mandatory_warnings()) == ['str', 'str1', 'unicode2']
    config.read_only()
    assert list(config.cfgimpl_get_values().mandatory_warnings()) == ['str', 'str1', 'unicode2']
    config.read_write()
    config.str = 'yes'
    assert list(config.cfgimpl_get_values().mandatory_warnings()) == ['str1', 'unicode2', 'str3']
    try:
        delete_session('config', 'man113')
    except ValueError:
        pass
    del(config)


def test_mandatory_od_disabled():
    descr = make_description()
    od = OptionDescription('od', '', [descr])
    config = Config(od, session_id='man114')
    config.read_only()
    assert list(config.cfgimpl_get_values().mandatory_warnings()) == ['tiram.str1', 'tiram.unicode2', 'tiram.str3']
    config.cfgimpl_get_settings()[descr].append('disabled')
    assert list(config.cfgimpl_get_values().mandatory_warnings()) == []
    try:
        delete_session('config', 'man114')
    except ValueError:
        pass
    del(config)
