# -*- coding: utf-8 -*-
# Copyright (C) 2013 Team tiramisu (see AUTHORS for all contributors)
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by the
# Free Software Foundation, either version 3 of the License, or (at your
# option) any later version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
# details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ____________________________________________________________
from tiramisu.i18n import _
from ..util import SerializeObject
from .util import SqlAlchemyBase
import util
from sqlalchemy import Column, Integer, String


class Setting(SerializeObject):
    """:param extension: database file extension (by default: db)
    :param dir_database: root database directory (by default: /tmp)
    """
    #FIXME
    extension = 'db'
    dir_database = '/tmp'


storage_setting = Setting()


class Session(SqlAlchemyBase):
    __tablename__ = 'session'
    id = Column(Integer, primary_key=True)
    session = Column(String, index=True)

    def __init__(self, session_id):
        self.session = session_id


def list_sessions():  # pragma: optional cover
    session = util.Session()
    ret = []
    for val in session.query(Session).all():
        ret.append(val.session)
    del(session)
    return ret


def delete_session(session_id, session):  # pragma: optional cover
    session.delete(session.query(Session).filter_by(session=session_id).first())
    session.commit()


def getsession():
    return util.Session()


class Storage(object):
    __slots__ = ('session_id', 'persistent')
    storage = 'sqlalchemy'
    #if object could be serializable
    serializable = True

    def __init__(self, session_id, persistent, test=False):
        session = getsession()
        self.session_id = session_id
        self.persistent = persistent
        if not session.query(Session).filter_by(session=session_id).first():  # pragma: optional cover
            session.add(Session(session_id))
            session.commit()
        del(session)

    def __del__(self):
        if not self.persistent:
            session = getsession()
            delete_session(self.session_id, session)
            del(session)
