#!/usr/bin/env python
# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007  
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr 
#  
# get_RPMS.py
#  
# script de lecture de la liste des paquets supplémentaires définis sur Zephir
#       
###########################################################################

from zephir.lib_zephir import zephir_dir

def get_rpms(path='%s/zephir_conf/' % zephir_dir):
    # récupération de la liste des RPMS additionnels (serveur et variante)
    liste_pkg = []
    #rechercher des paquetages
    for fichier in ['fichiers_variante','fichiers_zephir']:
        try:
            # lecture du fichier
            fic = open(path+fichier)
            data = fic.read().split("\n")
            fic.close()
        except:
            # un des fichiers n'a pas pu être lu
            pass
        else:
            # recherche de la section des RPMS
            section_rpm = 0
            for ligne in data:
                ligne = ligne.strip()
                if section_rpm == 1:
                    # on regarde si on a bien affaire à un paquetage
                    if not ligne.startswith('#') and ligne != '':
                        # on affiche le nom du paquetage
                        liste_pkg.append(ligne)
                if ligne == '%%':
                    section_rpm = 1
    return liste_pkg

if __name__ == '__main__':
    liste=get_rpms()
    for pkg in liste:
        print pkg
