# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################

"""

"""

try: _ # localized string fetch function
except NameError: _ = str

import os, dircache

from zephir.monitor.agentmanager import config as cfg
from zephir.monitor.agentmanager.agentdatamanager import AgentDataManager, LiveAgentsManager



class ClientManager:
    """Structure d'accès aux postes clients.

    Se comporte comme un dictionnaire C{{'nom client': AgentManager}}.

    TODO: utiliser UserDict.DictMixin
    """

    def __init__(self, config, live_agents=None):
        """
        @param live_agents: dictionnaire C{{client_name:
          L{LiveAgentsManager}}} pour les éventuels agents chargés en
          local.
        """
        self.config = config
        self.live_agents = {}
        if live_agents is not None:
            for client_name, agents in live_agents.items():
                self.live_agents[client_name] = LiveAgentsManager(self.config, client_name, agents)
        self.cache = {}

    def __getitem__(self, client_name):
        if self.has_live_key(client_name):
            return self.live_agents[client_name]
        elif self.has_archive_key(client_name):
            try:
                agents = self.cache[client_name]
            except KeyError:
                agents = AgentDataManager(self.config, client_name)
                self.cache[client_name] = agents
            return agents
        else:
            # data no more on disk, so cleanup the cache if it still
            # has an entry
            if self.cache.has_key(client_name):
                del self.cache[client_name]
            return None

    def has_live_key(self, client_name):
        """
        @return: C{True} si C{client_name} est le nom d'un agent local
        """
        return self.live_agents.has_key(client_name)
    
    def has_archive_key(self, client_name):
        """
        @return: C{True} si C{client_name} est le nom d'un agent
          archivé
        """
        d = cfg.client_data_dir(self.config, client_name)
        client_data_dir_exists = os.path.isdir(d)
        client_structure_exists = os.path.isfile(os.path.join(d, 'site.cfg'))
        return client_data_dir_exists and client_structure_exists

    def has_key(self, client_name):
        return (self.has_live_key(client_name)
                or self.has_archive_key(client_name))

    def keys(self):
        d = self.config['state_dir']
        archives = []
        for k in dircache.listdir(d):
            if self.has_archive_key(k) and not self.has_live_key(k):
                archives.append(k) # maybe add a link to the archived data in the web page?
        return self.live_agents.keys() + archives

    def items(self): #FIXME duplicated with AgentManager.items
        result = []
        for k in self.keys():
            result.append([k, self[k]])
        return result

# def test_main():
#     test_support.run_unittest(UserStringTest)
 
# if __name__ == "__main__":
#     test_main()
