# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################

"""
Singleton contenant les données globales de configuration.

Usage :
  from zephir.monitor.agentmanager import config as cfg
  cfg.whatever_you_need
"""

try: _ # localized string fetch function
except NameError: _ = str

import os
from datetime import datetime
try:
        from zephir.zephir_conf.zephir_conf import id_serveur
except:
        id_serveur=0


# VERSION DE DISTRIBUTION EOLE
distrib_version = 7

DEFAULT_CONFIG = {
    'host_ref': str(id_serveur), #zephircfg.id_serveur

    'webserver_port': 8090,
    'static_web_dir': os.path.join(os.path.curdir, 'static'),
    'static_base_url': '/static',

    'tmp_data_dir': os.path.join(os.path.curdir, 'data'),
    'config_dir': os.path.join(os.path.curdir, 'configs'),
    'state_dir': os.path.join(os.path.curdir, 'stats'),
    'uucp_dir': os.path.join(os.path.curdir, 'uucp'),
    'action_dir':  os.path.join(os.path.curdir, 'actions'),

    'upload_period': 600,
    }

# dans le cas de zephir, on garde toujours le répertoire 0 au lieu de
# l'identifiant zephir pour éviter un conflit avec les serveurs clients enregistrés
if os.path.isfile('/etc/init.d/zephir'):
    DEFAULT_CONFIG['host_ref'] = "0"


def client_data_dir(config, client_name):
    return os.path.join(config['state_dir'],
                        client_name)


def agent_data_dir(config, client_name, agent_name):
    return os.path.join(client_data_dir(config, client_name),
                        agent_name)


def agent_metadata_file(config, client_name, agent_name):
    return os.path.join(agent_data_dir(config, client_name, agent_name),
                        "agent.xml")


# internal constants
RRD_TIME_ORIGIN = datetime(1970,1,1)

