# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2011
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################

"""
Agent zephir pour les démons bacula
"""

from zephir.monitor.agentmanager.agent import Agent
from zephir.monitor.agentmanager.data import TableData
from zephir.monitor.agentmanager.util import status_to_img
from zephir.monitor.agentmanager import status


class BaculaServices(Agent):

    def __init__(self, name,
                 bacula_services, # dict {"host:port": "comment"}
                 **params):
        Agent.__init__(self, name, **params)
        self.bacula_services = bacula_services
        self.table = TableData([
            ('description', "Description", {'align':'left'}, None),
            ('status', "état", {'align':'center'}, status_to_img),
            ('stats', "Historique", {'align':'left'}, None),
            ('host', "Hôte", {'align':'left'}, None),
            ('port', "Port", {'align':'left'}, None),
            ])
        self.data = [self.table]


    def measure(self):
        mesures = []
        try:
            # recherche de l'identifiant zephir
            # (nécessaire pour l'url du graphe de status des 'sous agents')
            from zephir.zephir_conf.zephir_conf import id_serveur
        except:
            # si on est pas enregistré : 0
            id_serveur = 0

        for service in self.bacula_services:
            if self.manager.agents.has_key(service):
               serv_agent = self.manager.agents[service]
               if serv_agent.last_measure is not None:
                   status = serv_agent.last_measure.value['services'][0]['status']
                   description = serv_agent.last_measure.value['services'][0]['description']
                   mesures.append({ 'description': description,
                                    'host': serv_agent.last_measure.value['services'][0]['host'],
                                    'port': serv_agent.last_measure.value['services'][0]['port'],
                                    'status': status,
                                    'stats': '<img src=/agents/%s/%s/status.png alt="Historique (%s)"/>' % (id_serveur,service,service)})
                   self.measure_data[service]=[status,description]
               else:
                   mesures.append({ 'description': service,
                                    'host': '',
                                    'port': '',
                                    'status': '',
                                    'stats': ''})
        return {'services': mesures}


    def write_data(self):
        Agent.write_data(self)
        if self.last_measure is not None:
            self.table.table_data = self.last_measure.value['services']


    def check_status(self):
        """remonte une erreur si un des services est tombé"""
        if self.last_measure is not None:
            for service in self.last_measure.value['services']:
                if service['status'] == 'Off':
                    return status.Error()
        else:
            # pas de mesure connue
            return status.Unknown()
        return status.OK()


