# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################

"""
Surveillance d'un onduleur géré par nut
Nécessite un test préliminaire normalement réalisé dans la conf
"""

from zephir.monitor.agentmanager.agent import Agent
from zephir.monitor.agentmanager.data import HTMLData, TableData
from zephir.monitor.agentmanager import status
from twisted.internet.utils import getProcessOutput

def ze(var):
    """ suppression du 0 initial pour l'affichage """
    if var.startswith('0'):
        return var[1:]
    return var

# données tableau 1
cle1 = ['ups.mfr', 'ups.model', 'driver.name', 'driver.parameter.port', 
        'ups.status', 'battery.charge']
tab1 = {'ups.mfr':'Marque',
        'ups.model':'Modèle',
        'driver.name':'Driver utilisé',
        'driver.parameter.port':'Port utilisé',
        'ups.status':"Etat de l'onduleur",
        'battery.charge':'Charge batterie'
       }
cle2 = ['input.voltage', 'input.voltage.minimum', 'input.voltage.maximum',
        'battery.voltage', 'ups.load', 'ups.temperature', 'ups.test.result']
tab2 = {'input.voltage' : 'Tension en entrée',
        'input.voltage.minimum' : 'Tension minimale',
        'input.voltage.maximum' : 'Tension maximale',
        'battery.voltage' : 'Tension batterie',
        'ups.load' : "Taux d'occupation de l'onduleur",
        'ups.temperature' : "Température de la batterie",
        'ups.test.result' : 'Resultat du dernier test',
       }


class Nut(Agent):
    def __init__(self, name, monitor, **params):
        Agent.__init__(self, name, **params)
        # monitor : nom de l'onduleur à surveiller (ex : ondul@localhost)
        self.monitor = monitor
        self.status = status.OK()
        self.table = TableData([
            ('label', 'Onduleur', {'align':'center'}, None),
            ('value', '', {'align':'center'}, None)
            ])
        self.table2 = TableData([
            ('label', 'Informations supplémentaires', {'align':'center'}, None),
            ('value', '', {'align':'center'}, None)
            ])
        title = HTMLData("<h3>Surveillance de l'onduleur : <i>%s</i></h3>" % self.monitor)
        title2 = HTMLData("<h3>Données supplémentaires</h3>")
        self.data = [title, self.table, title2, self.table2]
 
    def measure(self):
        self.status = status.OK()

        res = getProcessOutput('/bin/upsc',
                               args = [self.monitor],
                               env = {'LC_ALL': 'C'})
        res.addCallback(self.measure_process)
        res.addErrback(self.error)
        return res

    def measure_process(self, result):
        listing = {}
        data1 = []
        data2 = []
        for line in result.splitlines():
            data = line.split(':')
            if data[0].strip() == 'ups.status':
                ups_status = data[1].strip()
            if data[0].strip() == 'battery.charge':
                if float(data[1].strip()) > 100:
                    # bug du genre 750 au lieu de 75 !
                    data[1] = str(float(data[1])/10)
                ups_charge = data[1].strip()
            listing[data[0]] = data[1].strip()
        # ETAT (statut != "On Line")
        if 'OL' not in ups_status.split(' '):
            if float(ups_charge) < 20:
                self.status = status.Error("Charge batterie Faible")
            else:
                self.status = status.Warn("Fonctionnement sur batterie")
        # réorganisation des données
        for var in cle1:
            if listing.has_key(var):
                if var == 'battery.charge':
                    data1.append({'label':tab1[var], 'value':"%s%%" % listing[var]})
                    continue
                data1.append({'label':tab1[var], 'value':listing[var]})
        for var in cle2:
            if listing.has_key(var):
                if 'voltage' in var:
                    data2.append({'label':tab2[var], 'value':"%sV" % listing[var]})
                    continue
                if var == 'ups.load':
                    data2.append({'label':tab2[var], 'value':"%s%%" % ze(listing[var])})
                    continue
                if var == 'ups.temperature':
                    data2.append({'label':tab2[var], 'value':"%s°C" % ze(listing[var])})
                    continue
                data2.append({'label':tab2[var], 'value':listing[var]})
        return { 'statistics' : data1, 'statistics2' : data2}

    def error(self, result):
        self.status = status.Error()
        msg = """Echec de la connexion à l'onduleur"""
        return { 'statistics' : [{'label':'Erreur', 'value':msg}],
                 'statistics2' : [{'label':'Erreur', 'value':msg}]}

    def write_data(self):
        Agent.write_data(self)
        if self.last_measure is not None:
            self.table.table_data = self.last_measure.value['statistics']
            self.table2.table_data = self.last_measure.value['statistics2']
            
    def check_status(self):
        return self.status
 
