from py.test import raises
import os, sys
HERE = os.path.abspath(os.path.dirname(__file__))
ZEPHIR = os.path.normpath(os.path.join(HERE, '..'))
print ZEPHIR
DATA = os.path.join(HERE,'data')
print DATA
sys.path.append(ZEPHIR)

from entpool import *

def setup_module(module):
    module.code_ent = 'LC'
    module.pool = ClientIdPool(module.code_ent, DATA)
    file(module.pool.state_file,'w').close()
    module.free_ids = 0

def test_add():
    assert pool.free_space == 0
    pool.add_free_range('LaaC0030','LaaC0039')
    assert pool.free == [(30, 39)]
    assert pool.free_space == 10
    pool.add_free_range('LaaC0000','LaaC0003')
    assert pool.free == [(0,3),(30,39)]
    assert pool.free_space == 14

def test_get_id():
    ids = ['LaaC0000','LaaC0001','LaaC0002','LaaC0003','LaaC0030','LaaC0031']
    for ent_id in ids:
        assert pool.get_next_id() == ent_id
    assert pool.free == [(32,39)]
    assert pool.free_space == 8

def test_save():
    pool.save_state()
    data = file(pool.state_file).read().strip()
    assert data == ("""32,39""")

def test_reload():
    pool.load_state()
    assert pool.free == [(32,39)]
    assert pool.free_space == 8

def test_init():
    pool2 = ClientIdPool(code_ent, DATA)
    assert pool.free == [(32,39)]
    assert pool.free_space == 8

def teardown_module(module):
    if os.path.isfile(module.pool.state_file):
        os.unlink(module.pool.state_file)
