# -*- coding: UTF-8 -*-

"""
Classe parente d'un agent python
"""

import time, os
from zephir.monitor.utils import createfile
from zephir.monitor.config import Config

class IAgent:
    """Interface que doit satisfaire un agent en python
    pour pouvoir bénéficier de l'héritage de la classe Agent()

    attributs nécessaires à un agent
    --------------------------------
    
    - self.name : nom de l'agent 
    
    - self.description : description de l'agent

    écriture dans les fichiers
    self.write_html()
    self.write_xml()

    """

    def _dump_html(self):
        """Formatage html du résultat 
        """
        pass
        
    def _dump_xml(self):
        """
        Formatage xml du résultat
        """
        pass
    
class Agent:
    def __init__(self):
        """
        - append_mode : 0 par défaut mode écrasement (pas d'ajout à la suite par le scheduler)
        - xml_filename : sortie xml
        - hml_filename : sortie html
        - satus : etat de l'agent (up|down)
        """
        cfg = Config()
        self.append_mode = 0
        self.date = time.strftime("%d/%m/%Y", time.localtime())
        self.xml_filename = cfg.get_xml_name(self.name) 
        self.html_filename = cfg.get_html_name(self.name) 
        self.status = "up"

    XML = """
<agent nom="%s" date="%s" description="%s" status="%s">
%s
</agent>
"""


    def first_time(self):
        """Permet un comportement différent de write_xml
        suivant la valeur du mode ajout 
        """
        if os.path.isfile(self.xml_filename):
            return False
        else:
            return True

    def set_status(self, status):
        """Fixe l'état de l'agent (up ou down)
        """
        if satus == "up" or status == "down":
            self.status = status
        else :
            raise Exception, "statut errone"
    
    def write_xml(self):
        """Ecriture du xml dans un fichier
        """
        test_first = False

        if self.first_time():
            test_first = True

        if not self.append_mode:
            fh = open(self.xml_filename, "w")
        else:
            fh = open(self.xml_filename, "a")

        if test_first or not self.append_mode:
            fh.write("""<?xml version="1.0" encoding="iso-8859-1"?>\n""")

        fh.write(self.XML % (self.name,self.date,self.description,self.status, self._dump_xml()))
        fh.close()

    def write_html(self):
        """Ecriture du html dans un fichier 
        """
        createfile(self.html_filename, self._dump_html())
    
    def __str__(self):
        return """<Agent : %s>""" % self.name
    
if __name__ == "__main__":
    pass
