# -*- coding: UTF-8 -*-
"""
Lis le fichier de configuration des agents et en propose des accès adéquats
"""
import os

PATH_ZEPHIR = "./"

from utils import readfile

import xmlite

ROOT_DIR = "."

XML_DIR = ROOT_DIR + os.sep + "xml"

HTML_DIR = ROOT_DIR + os.sep + "htm"

AGENT_DIR = ROOT_DIR + os.sep + "agent"

SITE_DIR = ROOT_DIR + os.sep + "site"

URL_DIR = "."

class Config:
    """
    Extrait les données du fichier de config
    """
    def __init__(self, file= "agents.cfg"):
        self.file = file
        self.dict_agent = self._get_agents()

    def _get_agents(self):
        """Récupère la liste des agents depuis un fichier
        { agent_name : (
        0 : script_name,
        1 : temps,
        2 : group,
        3 : group_description ) }
        """
        d = {}
        fh = open(self.file,"r")
        l = fh.read().split("\n")
        fh.close()
        for ligne in l :
            if not (ligne.startswith("#")  or ligne == "\n" or ligne == "") :
                agent, script, temps , group, title = ligne.split(";")
                d[str(agent)] = (str(script), int(temps), str(group), str(title))
        return d

    def get_agent_list(self):
        """Récupère la liste totale de tous les agents
        """
        return self.dict_agent.keys()

    def get_agent_group(self, group):
        """Récupère la liste des agents d'un groupe 
        """
        l = []
        for agent in self.dict_agent.keys():
            if self.dict_agent[agent][2] == group:
                l.append(agent)
        return l

    def get_agent_desc(self, agent):
        """Rapatrie l'attribut descripton de l'objet à partir du xml généré par l'agent.
        """
        xml_filename = self.get_xml_name(agent)
        # conversion du xml en liste
        l = xmlite.load(xml_filename) 
        # dictionnaire des attributs de la balise agent
        attrs = l[1][1]
        return attrs['description']
     
    def get_agent_script(self, agent_name):
        """Nom du script de l'agent
        """
        return AGENT_DIR + os.sep + self.dict_agent[agent_name][0]

    def get_xml_name(self, agent_name):
        """Nom xml de l'agent
        """
        return XML_DIR + os.sep + agent_name + ".xml"

    def get_html_name(self, name):
        """Nom long de la page html pour une sortie d'un agent
        """
        return HTML_DIR + os.sep + name + ".htm"

    def get_html_site(self, group_name):
        """Nom long de la page html d'un groupe
        """
        return SITE_DIR + os.sep + group_name + ".htm"

    def get_html_relative_name(self, group_name):
        """Nom court de la page html d'un groupe (pour les urls)
        """
        return URL_DIR + os.sep + group_name + ".htm"
    
    def get_agent_time(self, agent_name):
        """Intervalle de shedule d'un agent
        """
        return self.dict_agent[agent_name][1]

    def get_group_list(self):
        """Collecte les noms des groupes 
        """
        agents = self.dict_agent
        # collecte les noms des groupes d'agents
        groups = []
        for agent in agents.keys():
            groups.append(agents[agent][2])
        # elimine les doublons dans la liste
        group_list = []
        for group in groups:
            if not group in group_list:
                group_list.append(group)
        return group_list

    def get_group_desc(self, group_name):
        """Récupère la description d'un groupe d'agents à partir du fichier cfg
        """
        agents = self.dict_agent
        
        for agent in agents.keys():
            if agents[agent][2] == group_name:
                return agents[agent][3]

# tests

if __name__ == "__main__" :
    cfg = Config()
##     print cfg.get_group_list()
    print cfg.get_agent_desc("ls")
##     print cfg.get_agent_group("systeme")
