# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################

"""
Plugin pour TwistedMatrix et C{mktap}/C{twistd}.
"""

import gettext, locale, os, sys
from twisted.python import usage   # twisted command-line processing & logging

# install locales early
from zephir.monitor.agentmanager import ZEPHIRAGENTS_DATADIR
APP = 'zephir-agents'
DIR = os.path.join(ZEPHIRAGENTS_DATADIR, 'i18n')
gettext.install(APP, DIR, unicode=False)

from zephir.monitor.agentmanager import config as cfg
from zephir.monitor.agentmanager.util import expand_dirname
from zephir.monitor.agentmanager.zephirservice import ZephirService


class Options(usage.Options):
    optParameters = [
        ["config", None, cfg.DEFAULT_CONFIG['config_dir'],
         _("Directory to search for configurations when loading agents")],
        ["data", None, cfg.DEFAULT_CONFIG['state_dir'],
         _("Directory where state data will be stored")],
        ["archive", None, cfg.DEFAULT_CONFIG['uucp_dir'],
         _("Directory where the upload archive will be created")],
        ["static", None, cfg.DEFAULT_CONFIG['static_web_dir'],
         _("Directory for static web data (graphics, stylesheets...)")],
        ["actions", None, cfg.DEFAULT_CONFIG['action_dir'],
         _("Directory for agent action files")],
        ["static-base", None, cfg.DEFAULT_CONFIG['static_base_url'],
         _("Base URL path for static web data")],
        ["tmp", None, cfg.DEFAULT_CONFIG['tmp_data_dir'],
         _("Temporary folder for archiving data")],
        ]


def makeService(commandline_config):
    config = setup_config(commandline_config)
    # setup_filesystem_env()
    return ZephirService(config,serve_static=True).with_updater_and_publisher()


def setup_config(commandline_config):
    """Change stuff in C{cfg}"""

    config = cfg.DEFAULT_CONFIG.copy()
    # this could use some os.path.expanduser() and os.path.expandvars()
    config['config_dir'] = expand_dirname(commandline_config["config"])
    config['state_dir'] = expand_dirname(commandline_config["data"])
    config['uucp_dir'] = expand_dirname(commandline_config["archive"])
    config['static_web_dir'] = expand_dirname(commandline_config["static"])
    config['action_dir'] = expand_dirname(commandline_config["actions"])
    config['tmp_data_dir'] = expand_dirname(commandline_config["tmp"])
    config['static_base_url'] = commandline_config["static-base"]
    return config


#startLogging est géré par twistd
#def startService():
#    log.startLogging(sys.stdout)

