# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################

"""
Agent zephir listant le contenu de l'annaire LDAP
"""
import time
from scribe import ldapconf
from scribe import eoleldap
from zephir.monitor.agentmanager.agent import Agent
from zephir.monitor.agentmanager.data import HTMLData, TableData
from zephir.monitor.agentmanager import status
from zephir.monitor.agentmanager.util import log

def color(string):
    """
    colorie la chaine avec en HTML
    """
    return "<font color=\"red\">%s</font>" % string

def add(num1, num2) :
    """
    addition qui renvoit ??? si erreur
    """
    if '???' in (num1, num2):
        return '???'
    else:
        return(num1 + num2)

class LdapScribe(Agent):

    def __init__(self, name, **params):
        """
        Gestion du status :
            par défaut : OK
            Erreur si pas de connexion
            Warning si erreur lors d'une ou plusieurs requêtes
        """
        Agent.__init__(self, name, **params)

        self.status = status.OK()
        self.fail = 0
        self.lastwarn = ''

        title1 = HTMLData("<h3>Nombre d'utilisateurs<h3>")
        self.table1 = TableData([
           ('name', 'Utilisateurs', {'align':'center'}, None),
           ('nb', 'Nombre' , {'align':'center'}, None)
        ])

        title2 = HTMLData("<h3>Nombre de groupes<h3>")
        self.table2 = TableData([
           ('name', 'Groupes', {'align':'center'}, None),
           ('nb', 'Nombre' , {'align':'center'}, None)
        ])

        title3 = HTMLData("<h3>Nombre de partages<h3>")
        self.table3 = TableData([
           ('name', 'Partages', {'align':'center'}, None),
           ('nb', 'Nombre' , {'align':'center'}, None)
        ])

        title4 = HTMLData("<h3>Nombre de Postes<h3>")
        self.table4 = TableData([
           ('name', 'Postes', {'align':'center'}, None),
           ('nb', 'Nombre' , {'align':'center'}, None)
        ])

        self.data = [title1, self.table1, title2, self.table2,
                     title3, self.table3, title4, self.table4]

    def measure(self):
        """
            exécute toutes les requêtes nécessaires
        """
        conn = eoleldap.Ldap()
        try:
            conn.connect()
        except:
            time.sleep(2)
            reload(eoleldap)
            conn = eoleldap.Ldap()
            try:
                conn.connect()
            except Exception, err:
                log.msg('erreur connexion ldap : %s' % str(err))
                self.status = status.Warn(str(err))
                return {'statistics1' : [], 'statistics2' : [],
                        'statistics3' : [], 'statistics4' : []}

        # reset à chaque mesure
        self.status = status.OK()
        self.fail = 0
        self.lastwarn = ''

        # ------------------------------------------------------------------ #
        ## les utilisateurs ##
        statistics1 = []
        total1 = 0

        for label, filtre in [('Eleves', ldapconf.ELEVE_FILTER),
                              ('Enseignants', ldapconf.PROF_FILTER),
                              ('Responsables', ldapconf.RESPONSABLE_FILTER),
                              ('Administratifs', ldapconf.ADMINISTRATIF_FILTER),
                              ('Invités', ldapconf.AUTRE_FILTER),]:
            num = self._requete(conn, '(&%s)' % filtre, 'uid')
            total1 = add(total1, num)
            statistics1.append (
                    { 'name' : label,
                      'nb'   : num
                    })

        statistics1.append (
            { 'name' : color('Total'),
              'nb'   : color(total1)
            })


        # ------------------------------------------------------------------ #
        ## les groupes ##
        statistics2 = []
        total2 = 0

        for label, _type in [('Niveaux', 'Niveau'), ('Classes', 'Classe'),
            ('Options', 'Option'), ('Equipes pédagogiques', 'Equipe'),
            ('Matières', 'Matiere'), ('Services administratifs', 'Service'),
            ('Groupes de travail', 'Groupe'),]:
            num = self._requete(conn, '(&%s(type=%s))' % (ldapconf.GROUP_FILTER, _type), 'cn')
            total2 = add(total2, num)
            statistics2.append (
                    { 'name' : label,
                      'nb'   : num
                    })

        try:
            num = self._requete(conn, '(&%s)' % (ldapconf.GROUP_FILTER), 'cn') - total2
        except:
            num = '???'
        total2 = add(total2, num)
        # nomalement : 7 (DomainAdmins/DomainUsers/DomainComputers/PrintOperators
        #                 professeurs/eleves/administratifs)
        statistics2.append (
                { 'name' : 'Groupes spéciaux',
                  'nb'   : num
                })

        statistics2.append (
            { 'name' : color('Total'),
              'nb'   : color(total2)
            })

        # ------------------------------------------------------------------ #
        ## les partages ##

        statistics3 = []
        statistics3.append (
            { 'name' : color('Total'),
              'nb'   : color(self._requete(conn, '(objectclass=sambaFileShare)', 'cn'))
            })

        # ------------------------------------------------------------------ #
        ## les stations ##

        statistics4 = []
        statistics4.append (
            { 'name' : color('Total'),
              'nb'   : color(self._requete(conn, "(&(objectclass=posixAccount)(description=Computer))", 'cn'))
            })

        if self.fail >= 2 :
            self.status = status.Warn(self.lastwarn)

        return {'statistics1' : statistics1, 'statistics2' : statistics2,
                'statistics3' : statistics3, 'statistics4' : statistics4}

    def _requete(self, conn, filtre, attr):
        time.sleep(0.2)
        try:
            return len(conn._search(filtre, attr))
        except:
            try:
                # 2ème tentative
                time.sleep(2)
                return len(conn._search(filtre, attr))
            except Exception, err:
                log.msg('erreur requête ldap : %s' % str(err))
                self.lastwarn = str(err)
                self.fail += 1
                return '???'

    def write_data(self):
        Agent.write_data(self)
        if self.last_measure is not None:
            self.table2.table_data = self.last_measure.value['statistics2']
            self.table3.table_data = self.last_measure.value['statistics3']
            self.table1.table_data = self.last_measure.value['statistics1']
            self.table4.table_data = self.last_measure.value['statistics4']

    def check_status(self):
        return self.status

