# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################

"""
Agent zephir testant le résultat de la dernière sauvegarde
"""

from zephir.monitor.agentmanager.agent import Agent
from zephir.monitor.agentmanager.data import TableData
from zephir.monitor.agentmanager import status
from zephir.monitor.agentmanager.util import boolean_to_onoff, status_to_img
from pyeole.bacula import bacula_rapport_load, BACULA_RAPPORT_UNKNOWN, \
        BACULA_RAPPORT_OK, BACULA_RAPPORT_ERR

class Sauvegarde(Agent):

    def __init__(self, name, **params):
        Agent.__init__(self, name, **params)
        self.table = TableData([
            ('status', 'Statut', {'align':'center'}, status_to_img),
            ('type', 'Type de sauvegarde', {'align':'center'}, None),
            ('comment', 'Dernière sauvegarde', {'align':'center'}, None)])
        self.data = [self.table]
        self.status = status.OK()

    def measure(self):
        ret_pre = bacula_rapport_load('cronpre')
        ret_svg = bacula_rapport_load('sauvegarde')
        ret_ctlg = bacula_rapport_load('catalogue')
        status_pre = {BACULA_RAPPORT_UNKNOWN: status.Unknown(),
                BACULA_RAPPORT_OK: status.OK(),
                BACULA_RAPPORT_ERR: status.Error()}.get(ret_pre[0])
        status_svg = {BACULA_RAPPORT_UNKNOWN: status.Unknown(),
                BACULA_RAPPORT_OK: status.OK(),
                BACULA_RAPPORT_ERR: status.Error()}.get(ret_svg[0])
        status_ctlg = {BACULA_RAPPORT_UNKNOWN: status.Unknown(),
                BACULA_RAPPORT_OK: status.OK(),
                BACULA_RAPPORT_ERR: status.Error()}.get(ret_ctlg[0])
        res = [{ 'status': status_pre,
                 'type': 'préparation',
                 'comment': ret_svg[1]},
               { 'status': status_svg,
                 'type': 'sauvegarde',
                 'comment': ret_svg[1]},
               { 'status': status_ctlg,
                 'type': 'catalogue',
                 'comment': ret_ctlg[1]}]
        self.status = max(status_pre, status_svg, status_ctlg)
        return {'statistics': res }

    def write_data(self):
        Agent.write_data(self)
        if self.last_measure is not None:
            self.table.table_data = self.last_measure.value['statistics']

    def check_status(self):
        return self.status

