#!/usr/bin/env python
# -*- coding: UTF-8 -*-

"""

"""
import re #, commands
from twisted.python import log
from twisted.internet import defer
from twisted.internet.utils import getProcessOutput

from agentmanager.agent import Agent
from agentmanager.data import HTMLData, TableData
from agentmanager.util import percent


# column titles in /proc/net/dev
(IBYTES, IPACKETS, IERRS,
 IDROP, IFIFO, IFRAME, ICOMPRESSED, IMULTICAST,
 OBYTES, OPACKETS, OERRS,
 ODROP, OFIFO, OCOLLS, OCARRIER, OCOMPRESSED,
 ) = range(0,16)

IPADDRESS_RE = re.compile('(?<=addr:)\d\d?\d?.\d\d?\d?.\d\d?\d?.\d\d?\d?')
ERROR_RATE_ALERT_THRESHOLD = 10 # in percent


def stat_format(x):
    return "%.1f" % x

class Ifconfig(Agent):


    def __init__(self, name,
                 **params):
        Agent.__init__(self, name, **params)
        self.last_measure = None
        self.table = TableData([
            ('name', 'Nom', {'align':'right'}, None),
            ('address', 'Adresse', {'align':'left'}, None),
            ('input KB', 'Entrée (Ko)', {'align':'right'}, stat_format),
            ('input err%', '(% err)', {'align':'right'}, stat_format),
            ('output KB', 'Sortie (Ko)', {'align':'right'}, stat_format),
            ('output err%', '(% err)', {'align':'right'}, stat_format) ])
        self.data = [self.table]


    def measure(self):
        ifconfig = getProcessOutput('/sbin/ifconfig',
                                    env = {'LC_ALL': 'C'})
        catproc = getProcessOutput('/bin/cat',
                                   args = ['/proc/net/dev'],
                                   env = {'LC_ALL': 'C'})
        cmds = defer.DeferredList([ifconfig, catproc])
        cmds.addCallback(self.measure_process)
        return cmds
    
    def measure_process(self, cmds_results):
        [(ifconfig_success, ifconfig),
         (catproc_success, catproc)] = cmds_results
        assert ifconfig_success and catproc_success #FIXME
        
        # get address of each interface
        addresses = {}
        blocks = ifconfig.strip().split('\n\n')
        for b in blocks:
            name_line, addr_line = b.splitlines()[0:2]
            name = name_line.split()[0]
            addr_match = IPADDRESS_RE.search(addr_line)
            assert addr_match is not None #FIXME set agent status
            addr = addr_match.group()
            addresses[name] = addr
            
        # get interfaces statistics from /proc
        statistics = []
        lines = catproc.splitlines()[2:] # drop header lines
        for l in lines:
            if_name, stats = l.split(':')
            if_name = if_name.strip()
            if addresses.has_key(if_name):
                stats = stats.split()
                if_stats = {'name': if_name,
                            'address': addresses[if_name],
                            'input KB': float(stats[IBYTES])/1024.0,
                            'output KB': float(stats[OBYTES])/1024.0,
                            'input err%': percent(stats[IERRS], stats[IPACKETS]),
                            'output err%': percent(stats[OERRS], stats[OPACKETS]), }
                statistics.append(if_stats)
        return {'statistics': statistics}

    
    def save_measure(self, measure):
        Agent.save_measure(self, measure)
        self.last_measure = measure
        

    def write_data(self):
        Agent.write_data(self)
        if self.last_measure is not None:
            self.table.table_data = self.last_measure.value['statistics']


#     def check_status(self):
#         # check commands and files existence
#         NotImplemented




# def test_main():
#     test_support.run_unittest(UserStringTest)
 
# if __name__ == "__main__":
#     test_main()
